/*
 * Decompiled with CFR 0.152.
 */
package maito.datacollecting.oaipmh;

import java.util.Properties;
import maito.datacollecting.DataSource;
import maito.datacollecting.DataSourceException;
import maito.datacollecting.RecordParser;
import maito.datacollecting.oaipmh.ListRecords;
import maito.datacollecting.oaipmh.OAIPMHException;

public class OAIPMHDataSource
implements DataSource {
    private RecordParser recordParser;
    private String baseURL;
    private String metadataPrefix = "oai_dc";
    private String updated;
    private final int PART_SIZE = 100;

    public OAIPMHDataSource(Properties properties, RecordParser recordParser) throws DataSourceException {
        if (properties == null) {
            throw new DataSourceException("parameters missing");
        }
        this.baseURL = properties.getProperty("location");
        if (this.baseURL == null) {
            throw new DataSourceException("parameter baseURL missing");
        }
        this.updated = properties.getProperty("updated");
        this.recordParser = recordParser;
        if (this.recordParser == null) {
            throw new DataSourceException("parameter recordParser is null");
        }
    }

    public void update() throws DataSourceException {
        ListRecords listRecords = null;
        try {
            listRecords = new ListRecords(this.baseURL, this.metadataPrefix, this.updated);
        }
        catch (OAIPMHException oAIPMHException) {
            throw new DataSourceException(oAIPMHException.getMessage());
        }
        try {
            String string = listRecords.nextPart(100);
            while (string != null) {
                this.recordParser.putData(string);
                string = listRecords.nextPart(100);
            }
        }
        catch (OAIPMHException oAIPMHException) {
            throw new DataSourceException(oAIPMHException.getMessage());
        }
    }
}

