/*
 * Decompiled with CFR 0.152.
 */
package maito.datacollecting.oaipmh;

import maito.datacollecting.DataStorage;
import maito.datacollecting.Record;
import maito.datacollecting.RecordConstructor;
import maito.datacollecting.RecordParser;

public class OAIPMHRecordParser
implements RecordParser {
    private RecordConstructor recordConstructor;
    private DataStorage dataStorage;
    private StringBuffer buffer;

    public OAIPMHRecordParser(RecordConstructor recordConstructor, DataStorage dataStorage) {
        this.recordConstructor = recordConstructor;
        this.dataStorage = dataStorage;
        this.buffer = new StringBuffer();
    }

    public void putData(String string) {
        String string2;
        if (string != null) {
            this.buffer.append(string);
        }
        while ((string2 = this.extractRecord()) != null) {
            try {
                Record record = this.recordConstructor.constructRecord(string2);
                if (record == null) continue;
                this.dataStorage.addRecord(record, string2);
            }
            catch (Exception exception) {
                System.out.println(exception);
                exception.printStackTrace();
                throw new IllegalArgumentException();
            }
        }
    }

    private String extractRecord() {
        String string = "";
        String string2 = "<record>";
        String string3 = "</record>";
        int n = this.buffer.indexOf(string2);
        int n2 = this.buffer.indexOf(string3);
        if (n >= 0 && n2 >= 0) {
            string = this.buffer.substring(n, n2 + string3.length());
            this.buffer.delete(n, n2 + string3.length());
            return new String(string);
        }
        return null;
    }
}

