/*
 * Decompiled with CFR 0.152.
 */
package maito.datacollecting.quickformat;

import maito.datacollecting.DataStorage;
import maito.datacollecting.Record;
import maito.datacollecting.RecordConstructor;
import maito.datacollecting.RecordParser;

public class QuickformatRecordParser
implements RecordParser {
    private static final String[] VALIDFORMATIDS = new String[]{"1", "2.1", "2.2", "2", "3.1", "3", "4.1", "4.2", "4.3", "4.4", "4.5", "4"};
    private RecordConstructor recordConstructor;
    private DataStorage dataStorage;
    private StringBuffer buffer;
    private StringBuffer recordBuffer;
    private String format = null;
    private String sourceName = null;
    private boolean EOF = false;

    public QuickformatRecordParser(RecordConstructor recordConstructor, DataStorage dataStorage) {
        this.recordConstructor = recordConstructor;
        this.dataStorage = dataStorage;
        this.buffer = new StringBuffer();
        this.recordBuffer = new StringBuffer();
    }

    public void putData(String string) {
        if (string != null) {
            this.buffer.append(string);
        } else {
            this.EOF = true;
            this.buffer.append("\n");
        }
        this.parseRecord();
    }

    private void parseRecord() {
        int n;
        while ((n = this.buffer.indexOf("\n")) != -1) {
            this.parseLine(n);
        }
    }

    private void parseLine(int n) {
        String string = this.buffer.substring(0, n);
        this.buffer.delete(0, n + 1);
        string = string.trim();
        if (string.startsWith("#") || string.length() == 0) {
            String string2;
            Record record;
            if (this.EOF && this.buffer.length() == 0 && this.format.equals("1") && this.recordBuffer.length() != 0 && (record = this.recordConstructor.constructRecord(string2 = new String(this.recordBuffer))) != null) {
                this.dataStorage.addRecord(record, string2);
            }
        } else if (this.format == null) {
            for (int i = 0; i < VALIDFORMATIDS.length; ++i) {
                if (!string.equals(VALIDFORMATIDS[i])) continue;
                this.format = string;
            }
            if (this.format == null) {
                throw new IllegalArgumentException("No valid format tag found in quickformat data");
            }
        } else if (this.sourceName == null) {
            this.sourceName = string;
        } else if (this.format.equals("1")) {
            if (string.equals("---") || this.EOF && this.buffer.length() == 0) {
                if (this.EOF) {
                    this.recordBuffer.append(string + "\n");
                }
                if (this.recordBuffer.length() != 0) {
                    String string3 = new String(this.recordBuffer);
                    Record record = this.recordConstructor.constructRecord(string3);
                    if (record != null) {
                        this.dataStorage.addRecord(record, string3);
                    }
                    this.recordBuffer.delete(0, this.recordBuffer.length());
                }
            }
            this.recordBuffer.append(string + "\n");
        } else {
            Record record = this.recordConstructor.constructRecord(this.format + string);
            if (record != null) {
                this.dataStorage.addRecord(record, string);
            }
        }
    }
}

