/*
 * Decompiled with CFR 0.152.
 */
package maito.integration;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import maito.datacollecting.Record;
import maito.integration.IntegrationException;
import maito.resource.Resource;
import maito.util.DbTools;
import maito.util.Tools;

public class IntegratorHelper {
    private Properties docFieldmap;
    private Properties actorFieldmap;
    private Properties quickNameFieldmap;

    public IntegratorHelper(Properties properties, Properties properties2, Properties properties3) {
        this.docFieldmap = properties;
        this.actorFieldmap = properties2;
        this.quickNameFieldmap = properties3;
    }

    public void integrateDocument(Connection connection, String string, Record record) throws IntegrationException {
        String[] stringArray;
        String string2;
        String string3 = null;
        Resource resource = null;
        String string4 = IntegratorHelper.getFirstVal(record.getField("KanoNimeke"));
        if (string4 == null || string4.equals("")) {
            string4 = Tools.canonizeGeneric(IntegratorHelper.getFirstVal(record.getField("Nimeke")));
            if (string4 == null) {
                string4 = "";
            }
            record.setField("KanoNimeke", string4);
        }
        resource = this.getResource(connection, "Document", null, IntegratorHelper.createDocID(record), string4);
        string3 = resource.getID();
        resource.setOverwrite(false);
        resource.setField("Records." + string + "\u00a4" + record.getID(), DbTools.formatDate(new Date()));
        for (String string5 : record.getFieldNames()) {
            string2 = this.docFieldmap.getProperty(string5);
            if (string2 == null) continue;
            stringArray = record.getField(string5);
            for (String string6 : stringArray) {
                IntegratorHelper.debug("Set field " + string5 + " > " + string2 + " - value: " + string6 + ", status: " + resource.setField(string2, string6));
            }
            String[] object2 = string4.split(" ");
            if (object2 == null) continue;
            for (int i = 0; i < object2.length; ++i) {
                resource.setField("KeyWords.keyword", object2[i]);
            }
        }
        resource.setField("Resource.name", "");
        resource.setField("Resource.canonicalName", "");
        resource.save(connection);
        for (String string5 : record.getFieldNames()) {
            string2 = this.actorFieldmap.getProperty(string5);
            if (string2 == null) continue;
            stringArray = string2.split(",");
            Vector vector = record.getField(string5);
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                String string7 = null;
                String string8 = (String)iterator.next();
                String string9 = Tools.canonizeGeneric(string8);
                Resource resource2 = null;
                resource2 = this.getResource(connection, stringArray[0], stringArray[1], string8, string9);
                string7 = resource2.getID();
                resource2.setField("Resource.name", string8);
                resource2.setField("Resource.canonicalName", string9);
                resource2.setField(stringArray[0] + ".type", stringArray[1]);
                resource2.save(connection);
                this.createRelation(connection, string7, string3, stringArray[2], false);
            }
        }
    }

    public void integrateNameQuickFormat(Connection connection, String string, Record record) throws IntegrationException {
        String string2;
        String string3 = null;
        Vector vector = record.getField("OrganisaatioHallinnoija");
        if (vector != null) {
            string3 = IntegratorHelper.getFirstVal(vector);
            record.deleteField("OrganisaatioHallinnoija");
        }
        Resource resource = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        for (Object object : record.getFieldNames()) {
            string2 = this.quickNameFieldmap.getProperty((String)object);
            if (string2 == null || !string2.startsWith("Resource.name,") || (vector = record.getField((String)object)) == null) continue;
            String[] stringArray = string2.split(",");
            string4 = stringArray[1];
            string5 = stringArray[2];
            string6 = IntegratorHelper.getFirstVal(vector);
            string7 = Tools.canonizeGeneric(string6);
            resource = this.getResource(connection, string4, string5, string6, string7);
            break;
        }
        if (resource == null) {
            return;
        }
        resource.setOverwrite(true);
        resource.setField("Resource.name", string6);
        resource.setField(string4 + ".type", string5);
        resource.setField("Records." + string + "\u00a4" + record.getID(), DbTools.formatDate(new Date()));
        for (Object object : record.getFieldNames()) {
            string2 = this.quickNameFieldmap.getProperty((String)object);
            if (string2 == null) continue;
            int n = string2.indexOf(",");
            if (n > 0) {
                string2 = string2.substring(0, n);
            }
            vector = record.getField((String)object);
            for (String string8 : vector) {
                IntegratorHelper.debug("Set field " + (String)object + " > " + string2 + " - value: " + string8 + ", status: " + resource.setField(string2, string8));
            }
        }
        resource.save(connection);
        if (string3 != null) {
            Object object;
            IntegratorHelper.debug("Creating Hallinnoija " + string3);
            string7 = Tools.canonizeGeneric(string3);
            object = this.getResource(connection, "Actor", "Organisaatio", string3, string7);
            ((Resource)object).setField("Resource.name", string3);
            ((Resource)object).setField("Actor.type", "Organisaatio");
            ((Resource)object).setField("Records." + string + "\u00a4" + record.getID(), DbTools.formatDate(new Date()));
            ((Resource)object).save(connection);
            this.createRelation(connection, ((Resource)object).getID(), resource.getID(), "Hallinnoija", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveDocumentReferences(Connection connection, Record record, String string) throws IntegrationException {
        Statement statement = null;
        ResultSet resultSet = null;
        String string2 = "";
        try {
            statement = connection.createStatement();
            for (int i = 0; i < 2; ++i) {
                Vector vector = record.getField(i == 0 ? "Viitattu" : "Viittaava");
                if (vector == null) continue;
                for (String string3 : vector) {
                    string2 = "SELECT id FROM Resource, ExtIDs WHERE id=resource AND type='Document' AND extID=" + DbTools.SQLstr(string3, 100);
                    resultSet = statement.executeQuery(string2);
                    if (resultSet.next()) {
                        do {
                            this.createRelation(connection, IntegratorHelper.createDocID(record), resultSet.getString(1), "BIBREF", i == 1);
                        } while (resultSet.next());
                        continue;
                    }
                    Resource resource = new Resource(string3, "Document");
                    string3 = resource.findUniqueID(connection);
                    resource.setField("ExtIDs.extID", string3);
                    resource.setField("Records." + string + "\u00a4" + record.getID(), DbTools.formatDate(new Date()));
                    resource.save(connection);
                    this.createRelation(connection, IntegratorHelper.createDocID(record), string3, "BIBREF", i == 1);
                }
            }
        }
        catch (SQLException sQLException) {
            System.out.println("resolveDocRefs failed with record: " + record.getID() + "\nSQLex: " + sQLException.getMessage());
            System.out.println("Continuing anyway...");
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    public Resource getResource(Connection connection, String string, String string2, String string3, String string4) throws IntegrationException {
        Statement statement = null;
        ResultSet resultSet = null;
        String string5 = "";
        try {
            statement = connection.createStatement();
            string5 = "SELECT Resource.id FROM Resource, " + string + " WHERE Resource.id=" + string + ".id AND" + " canonicalName='" + DbTools.escSQL(string4) + "'";
            if (string2 != null) {
                string5 = string5 + " AND " + string + ".type='" + string2 + "'";
            }
            IntegratorHelper.debug(string5);
            resultSet = statement.executeQuery(string5);
            String string6 = null;
            if (resultSet.next()) {
                string6 = resultSet.getString(1);
            }
            Resource resource = null;
            if (string6 != null) {
                resource = new Resource(string6, string);
                boolean bl = resource.load(connection);
                IntegratorHelper.debug(string + " resource loaded: " + string6 + ", status: " + bl);
            } else {
                resource = new Resource(string3, string);
                string6 = resource.findUniqueID(connection);
                resource.setField("Resource.canonicalName", string4);
                if (string2 != null) {
                    resource.setField(string + ".type", string2);
                }
                IntegratorHelper.debug("Created new " + string + " resource, id=" + string6);
            }
            Resource resource2 = resource;
            return resource2;
        }
        catch (SQLException sQLException) {
            throw new IntegrationException("getRelation failed SQLex(" + sQLException.getMessage() + ")\nPrevious query: " + string5);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    public void createRelation(Connection connection, String string, String string2, String string3, boolean bl) throws IntegrationException {
        String string4;
        if (string == null || string2 == null || string3 == null) {
            return;
        }
        if (bl) {
            string4 = string2;
            string2 = string;
            string = string4;
        }
        string4 = DbTools.SQLstr(string, 100);
        String string5 = DbTools.SQLstr(string2, 100);
        boolean bl2 = true;
        Statement statement = null;
        ResultSet resultSet = null;
        String string6 = "";
        try {
            bl2 = connection.getAutoCommit();
            connection.setAutoCommit(false);
            statement = connection.createStatement();
            if (string3.equals("NONE") || string3.equals("BIBREF")) {
                string6 = "SELECT * FROM ResourceRelation WHERE role='" + string3 + "' AND subject=" + string4 + " AND object=" + string5;
                IntegratorHelper.debug(string6);
                resultSet = statement.executeQuery(string6);
                if (!resultSet.next()) {
                    string6 = "INSERT INTO ResourceRelation SET role='" + string3 + "',subject=" + string4 + ",object=" + string5;
                    IntegratorHelper.debug(string6);
                    statement.executeUpdate(string6);
                }
            } else {
                string6 = "SELECT Role.id FROM Role, ResourceRelation WHERE Role.id=ResourceRelation.role AND object=" + string5 + " AND Role.type='" + string3 + "'";
                resultSet = statement.executeQuery(string6);
                IntegratorHelper.debug(string6);
                String string7 = null;
                if (resultSet.next()) {
                    string7 = resultSet.getString(1);
                } else {
                    Resource resource = new Resource(string3 + "_" + string2, "Role");
                    string7 = resource.findUniqueID(connection);
                    resource.setField("Resource.name", "");
                    resource.setField("Resource.canonicalName", "");
                    resource.setField("Role.type", string3);
                    resource.save(connection);
                }
                string6 = "SELECT Role.id FROM Role, ResourceRelation WHERE Role.id=ResourceRelation.role AND object=" + string5 + " AND Role.type='" + string3 + "' " + "AND subject=" + string4;
                resultSet = statement.executeQuery(string6);
                if (!resultSet.next()) {
                    string6 = "INSERT INTO ResourceRelation SET role=" + DbTools.SQLstr(string7, 100) + ",subject=" + string4 + ",object=" + string5;
                    IntegratorHelper.debug(string6);
                    statement.executeUpdate(string6);
                }
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            throw new IntegrationException("createRelation failed SQLex(" + sQLException.getMessage() + ")\nPrevious query: " + string6);
        }
        finally {
            try {
                connection.setAutoCommit(bl2);
            }
            catch (SQLException sQLException) {}
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    public static String createDocID(Record record) {
        char c;
        String string = null;
        String[] stringArray = new String[]{"Henkil\u00f6Tekij\u00e4", "OrganisaatioTekij\u00e4", "JokuTekij\u00e4"};
        String string2 = null;
        for (int i = 0; i < stringArray.length && string2 == null; ++i) {
            string2 = IntegratorHelper.getFirstVal(record.getField(stringArray[i]));
        }
        string = string2 != null && string2.length() >= 3 ? string2.substring(0, 3) : "xxx";
        String string3 = IntegratorHelper.getFirstVal(record.getField("Julkaisup\u00e4iv\u00e4m\u00e4\u00e4r\u00e4"));
        string = string3 != null && string3.length() >= 4 ? string + string3.substring(2, 4) : string + "XX";
        String string4 = IntegratorHelper.getFirstVal(record.getField("Nimeke"));
        if (string4 != null && string4.length() > 3) {
            String[] stringArray2 = string4.split(" ");
            String string5 = null;
            for (c = '\u0000'; c < stringArray2.length; ++c) {
                if (stringArray2[c].length() <= 3) continue;
                string5 = stringArray2[c];
                break;
            }
            if (string5 == null) {
                string5 = "xxxx";
            }
            string = string + string5;
        } else {
            string = string + "xxxx";
        }
        if (string.equals("xxxXXxxxx")) {
            string = "";
            for (int i = 0; i < 6; ++i) {
                int n = (int)(Math.random() * 25.0);
                c = (char)(97 + n);
                string = string + "" + c;
            }
        }
        return string;
    }

    public static String getFirstVal(Vector vector) {
        if (vector == null) {
            return null;
        }
        try {
            return (String)vector.get(0);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    private static void debug(String string) {
    }
}

