/*
 * Decompiled with CFR 0.152.
 */
package maito.integration;

import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import maito.LogListener;
import maito.datacollecting.DataSourceDescription;
import maito.datacollecting.Record;
import maito.integration.IntegrationException;
import maito.integration.Integrator;
import maito.integration.IntegratorHelper;
import maito.integration.RecordReader;
import maito.util.DbTools;
import maito.util.Tools;

public class IntegratorImpl
implements Integrator {
    private IntegratorHelper iHelper;
    private Properties dbConfig = Tools.loadProperties(Tools.PATH_DBCONFIG);
    private int integrationTasks = 0;

    public IntegratorImpl() {
        Properties properties;
        Properties properties2;
        Properties properties3;
        if (this.dbConfig == null) {
            System.out.println("ERROR: Could not load dbconfig.properties");
        }
        if ((properties3 = Tools.loadProperties("config" + File.separator + "fieldmap_document.properties")) == null) {
            System.out.println("ERROR: Could not load fieldmap_document.properties");
        }
        if ((properties2 = Tools.loadProperties("config" + File.separator + "fieldmap_actorchannel.properties")) == null) {
            System.out.println("ERROR: Could not load fieldmap_document.properties");
        }
        if ((properties = Tools.loadProperties("config" + File.separator + "fieldmap_qnformat.properties")) == null) {
            System.out.println("ERROR: Could not load fieldmap_qnformat.properties");
        }
        this.iHelper = new IntegratorHelper(properties3, properties2, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGraph(String string) throws IllegalArgumentException {
        if (string == null || string.length() < 1) {
            throw new IllegalArgumentException("graphName was null or empty");
        }
        String string2 = this.dbConfig.getProperty("dbname_resources") + "_" + string;
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = DbTools.createDbConnection(this.dbConfig);
            statement = connection.createStatement();
            resultSet = statement.executeQuery("SHOW DATABASES LIKE '" + string2 + "'");
            if (!resultSet.next()) {
                String string3 = Tools.readFile(Tools.PATH_RESOURCEGRAPH_SQL);
                if (string3 == null) {
                    System.out.println("ERROR: Error loading sql script file: resourcegraph.sql");
                    return;
                }
                statement.executeUpdate("CREATE DATABASE IF NOT EXISTS " + string2 + " CHARACTER SET utf8");
                statement.executeUpdate("USE " + string2);
                IntegratorImpl.debug("Creating database from script");
                int n = 0;
                int n2 = string3.indexOf(";", n);
                while (n2 != -1) {
                    String string4 = string3.substring(n, n2);
                    IntegratorImpl.debug("SQL: " + string4);
                    statement.executeUpdate(string4);
                    n = n2 + 1;
                    n2 = string3.indexOf(";", n);
                }
            }
        }
        catch (SQLException sQLException) {
            System.out.println("ERROR: " + sQLException.getMessage());
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getGraphs() {
        Vector<String> vector = new Vector<String>();
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = DbTools.createDbConnection(this.dbConfig);
            statement = connection.createStatement();
            resultSet = statement.executeQuery("SHOW DATABASES LIKE '" + this.dbConfig.getProperty("dbname_resources") + "%'");
            while (resultSet.next()) {
                String string = resultSet.getString(1);
                int n = this.dbConfig.getProperty("dbname_resources").length() + 1;
                vector.add(string.substring(n));
            }
        }
        catch (SQLException sQLException) {
            System.out.println("ERROR: " + sQLException.getMessage());
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getSources(String string) throws IllegalArgumentException {
        if (string == null || string.length() < 1) {
            throw new IllegalArgumentException("graphName was null or empty");
        }
        String string2 = this.dbConfig.getProperty("dbname_resources") + "_" + string;
        Vector<String[]> vector = new Vector<String[]>();
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = DbTools.createDbConnection(this.dbConfig);
            statement = connection.createStatement();
            statement.execute("USE " + string2);
            resultSet = statement.executeQuery("SELECT sourceID, integrated FROM DataSources");
            while (resultSet.next()) {
                String[] stringArray = new String[]{resultSet.getString(1), resultSet.getString(2)};
                vector.add(stringArray);
            }
        }
        catch (SQLException sQLException) {
            System.out.println("ERROR: " + sQLException.getMessage());
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return vector;
    }

    public void integrate(DataSourceDescription[] dataSourceDescriptionArray, String string) throws IntegrationException {
        this.taskStarted();
        IntegrationThread integrationThread = new IntegrationThread(this, dataSourceDescriptionArray, string);
        integrationThread.start();
        System.out.println("Integration started");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void doIntegration(DataSourceDescription[] dataSourceDescriptionArray, String string) {
        block60: {
            String string2 = this.dbConfig.getProperty("dbname_rawdata");
            String string3 = this.dbConfig.getProperty("dbname_resources") + "_" + string;
            String string4 = null;
            Connection connection = null;
            Connection connection2 = null;
            Statement statement = null;
            Statement statement2 = null;
            ResultSet resultSet = null;
            System.out.println("raw db: " + string2);
            connection = DbTools.createDbConnection(this.dbConfig, string2);
            statement = connection.createStatement();
            RecordReader recordReader = new RecordReader(connection);
            connection2 = DbTools.createDbConnection(this.dbConfig, string3);
            statement2 = connection2.createStatement();
            for (int i = 0; i < dataSourceDescriptionArray.length; ++i) {
                String string5;
                String string6 = dataSourceDescriptionArray[i].getId();
                string4 = "SELECT * FROM DataSources where sourceID=" + DbTools.SQLstr(string6, 100);
                IntegratorImpl.debug(string4);
                resultSet = statement2.executeQuery(string4);
                if (!resultSet.next()) {
                    string4 = "INSERT INTO DataSources SET sourceID=" + DbTools.SQLstr(string6, 100) + ", integrated=CURDATE()";
                    IntegratorImpl.debug(string4);
                    statement2.executeUpdate(string4);
                }
                recordReader.getRecords(dataSourceDescriptionArray[i]);
                Record record = null;
                while ((record = recordReader.nextRecord()) != null) {
                    string5 = record.getID();
                    String string7 = record.getIntegratedTo();
                    if (string7 == null) {
                        string7 = "";
                    }
                    if (string7.indexOf(string) == -1) {
                        if (dataSourceDescriptionArray[i].getDataFormat().equals("quick_format_name")) {
                            string4 = "UPDATE DataRecord SET integratedTo='" + string7 + string + ",' WHERE id=" + DbTools.SQLstr(string5, 200) + " AND source=" + DbTools.SQLstr(string6, 100);
                            IntegratorImpl.debug(string4);
                            statement.executeUpdate(string4);
                        }
                    } else {
                        IntegratorImpl.debug("*** Record already integrated, continuing");
                        continue;
                    }
                    if (dataSourceDescriptionArray[i].getDataFormat().equals("quick_format_name")) {
                        IntegratorImpl.debug("Starting name format integration");
                        try {
                            this.iHelper.integrateNameQuickFormat(connection2, string6, record);
                        }
                        catch (IntegrationException integrationException) {
                            System.out.println("An exception occured when trying to integrate a namequickformat record:");
                            System.out.println(integrationException.getMessage());
                            System.out.println("Continuing anyway...");
                        }
                        continue;
                    }
                    IntegratorImpl.debug("*** Starting document integration");
                    try {
                        this.iHelper.integrateDocument(connection2, string6, record);
                    }
                    catch (IntegrationException integrationException) {
                        System.out.println("An exception occured when trying to integrate a document record:");
                        System.out.println(integrationException.getMessage());
                        System.out.println("Continuing anyway...");
                    }
                }
                if (dataSourceDescriptionArray[i].getDataFormat().equals("quick_format_name")) continue;
                recordReader.getRecords(dataSourceDescriptionArray[i]);
                while ((record = recordReader.nextRecord()) != null) {
                    string5 = record.getIntegratedTo();
                    if (string5 == null) {
                        string5 = "";
                    }
                    if (string5.indexOf(string) != -1) {
                        IntegratorImpl.debug("*** DocRecord already integrated (skip)");
                        continue;
                    }
                    string4 = "UPDATE DataRecord SET integratedTo='" + string5 + string + ",' WHERE id=" + DbTools.SQLstr(record.getID(), 200) + " AND source=" + DbTools.SQLstr(string6, 100);
                    IntegratorImpl.debug(string4);
                    statement.executeUpdate(string4);
                    IntegratorImpl.debug("*** Starting to resolve document references");
                    try {
                        this.iHelper.resolveDocumentReferences(connection2, record, string6);
                    }
                    catch (IntegrationException integrationException) {
                        System.out.println("An exception occured when trying to resolve document references:");
                        System.out.println(integrationException.getMessage());
                        System.out.println("Continuing anyway...");
                    }
                }
            }
            recordReader.close();
            Object var19_22 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                if (statement2 != null) {
                    statement2.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                if (connection2 != null) {
                    connection2.close();
                }
                break block60;
            }
            catch (SQLException sQLException) {}
            break block60;
            {
                catch (SQLException sQLException) {
                    System.out.println("doIntSQLERROR: " + sQLException.getMessage());
                    sQLException.printStackTrace();
                    Object var19_23 = null;
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                    catch (SQLException sQLException2) {
                        // empty catch block
                    }
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                    }
                    catch (SQLException sQLException2) {
                        // empty catch block
                    }
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException2) {
                        // empty catch block
                    }
                    try {
                        if (statement2 != null) {
                            statement2.close();
                        }
                    }
                    catch (SQLException sQLException2) {
                        // empty catch block
                    }
                    try {
                        if (connection2 != null) {
                            connection2.close();
                        }
                        break block60;
                    }
                    catch (SQLException sQLException2) {}
                }
            }
            catch (Throwable throwable) {
                Object var19_24 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    if (statement2 != null) {
                        statement2.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    if (connection2 != null) {
                        connection2.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public String setLogListener(String string, LogListener logListener) {
        return null;
    }

    public boolean workInProgress() {
        return this.integrationTasks > 0;
    }

    public String[] getCurrentTasks() {
        return null;
    }

    protected synchronized void taskStarted() {
        ++this.integrationTasks;
    }

    protected synchronized void taskEnded() {
        --this.integrationTasks;
    }

    public String[] getErrors() {
        return null;
    }

    public void setLogListener(LogListener logListener) {
    }

    public static void debug(String string) {
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 2) {
            System.out.println("Give datasource id as first parameter & name of resourcegraph as second parameter.");
            return;
        }
        IntegratorImpl integratorImpl = new IntegratorImpl();
        integratorImpl.addGraph(stringArray[1]);
        DataSourceDescription dataSourceDescription = new DataSourceDescription(stringArray[0], "", "", 1L, "", false);
        DataSourceDescription[] dataSourceDescriptionArray = new DataSourceDescription[]{dataSourceDescription};
        integratorImpl.integrate(dataSourceDescriptionArray, stringArray[1]);
    }

    class IntegrationThread
    extends Thread {
        private IntegratorImpl parent;
        private DataSourceDescription[] sources;
        private String graph;

        public IntegrationThread(IntegratorImpl integratorImpl2, DataSourceDescription[] dataSourceDescriptionArray, String string) {
            this.parent = integratorImpl2;
            this.sources = dataSourceDescriptionArray;
            this.graph = string;
        }

        public void run() {
            IntegratorImpl.this.doIntegration(this.sources, this.graph);
            this.parent.taskEnded();
        }
    }
}

