/*
 * Decompiled with CFR 0.152.
 */
package maito.integration;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import maito.datacollecting.DataSourceDescription;
import maito.datacollecting.Record;
import maito.util.DbTools;

public class RecordReader {
    private Connection conn;
    private Statement stmt;
    private ResultSet rs;
    private String currentSourceId;

    public RecordReader(Connection connection) {
        this.conn = connection;
        this.stmt = null;
        this.rs = null;
        this.currentSourceId = null;
    }

    public void getRecords(DataSourceDescription dataSourceDescription) {
        block8: {
            if (this.currentSourceId != null && dataSourceDescription.getId().equals(this.currentSourceId)) {
                try {
                    if (this.rs != null) {
                        this.rs.first();
                    }
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
                return;
            }
            this.close();
            this.currentSourceId = dataSourceDescription.getId();
            try {
                this.stmt = this.conn.createStatement(1007, 1004);
                String string = "SELECT record, name, value, integratedTo FROM Statement, DataRecord WHERE Statement.record=DataRecord.id AND Statement.source=DataRecord.source AND DataRecord.source='" + DbTools.escSQL(dataSourceDescription.getId()) + "'";
                this.rs = this.stmt.executeQuery(string);
                if (this.rs.next()) break block8;
                try {
                    this.rs.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.rs = null;
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
    }

    public Record nextRecord() {
        if (this.rs == null) {
            return null;
        }
        try {
            if (this.rs.isAfterLast()) {
                return null;
            }
            Record record = new Record(this.rs.getString("record"));
            record.setIntegratedTo(this.rs.getString("integratedTo"));
            while (this.rs.getString("Record").equals(record.getID())) {
                record.setField(this.rs.getString("name"), this.rs.getString("value"));
                this.rs.next();
                if (!this.rs.isAfterLast()) continue;
            }
            return record;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return null;
        }
    }

    public void close() {
        if (this.rs != null) {
            try {
                this.rs.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.stmt != null) {
            try {
                this.stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

