/*
 * Decompiled with CFR 0.152.
 */
package maito.resource;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import maito.util.DbTools;

public class Resource {
    public static final int IDLENGTH = 100;
    private String id;
    private String type;
    private HashMap data;
    private HashMap extraData;
    private HashMap records;
    private HashSet extIDs;
    private HashSet keyWords;
    private boolean loaded = false;
    private boolean overwrite = false;

    public Resource(String string, String string2) {
        if (string == null) {
            string = "";
        }
        this.id = string.length() > 100 ? string.substring(0, 100) : string;
        this.type = string2;
        this.data = new HashMap();
        this.data.put("created", DbTools.formatDate(new Date()));
        this.extraData = new HashMap();
        this.records = new HashMap();
        this.extIDs = new HashSet();
        this.keyWords = new HashSet();
    }

    public void setOverwrite(boolean bl) {
        this.overwrite = bl;
    }

    public boolean getOverwrite() {
        return this.overwrite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String findUniqueID(Connection connection) {
        Statement statement = null;
        ResultSet resultSet = null;
        String string = this.id;
        int n = 1;
        String string2 = "";
        try {
            statement = connection.createStatement();
            string2 = "SELECT id FROM Resource WHERE id='" + DbTools.escSQL(string) + "'";
            resultSet = statement.executeQuery(string2);
            while (resultSet.next()) {
                int n2 = (string + ++n).length() - 100;
                if (n2 > 0) {
                    string = string.substring(0, string.length() - n2);
                }
                string2 = "SELECT id FROM Resource WHERE id='" + DbTools.escSQL(string + n) + "'";
                resultSet = statement.executeQuery(string2);
            }
            if (n > 1) {
                this.id = string + n;
            }
            String string3 = this.id;
            return string3;
        }
        catch (SQLException sQLException) {
            System.out.println("SQL ERROR (Resource.load): " + sQLException.getMessage());
            System.out.println("Previous query: " + string2);
            String string4 = null;
            return string4;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public String getID() {
        return this.id;
    }

    public boolean setField(String string, String string2) {
        if (string == null) {
            return false;
        }
        int n = string.indexOf(".");
        if (n == -1) {
            return false;
        }
        String string3 = string.substring(0, n);
        string = string.substring(n + 1, string.length());
        if (string3.equals("Resource")) {
            if (!string.equals("name") && !string.equals("canonicalName")) {
                return false;
            }
            if (this.overwrite || this.data.get(string) == null || this.data.get(string).equals("")) {
                this.data.put(string, string2);
                return true;
            }
        } else if (string3.equals("Role") || string3.equals("Actor") || string3.equals("Channel")) {
            if (!string.equals("type")) {
                return false;
            }
            if (this.overwrite || this.extraData.get(string) == null || this.extraData.get(string).equals("")) {
                this.extraData.put(string, string2);
                return true;
            }
        } else if (string3.equals("Document")) {
            if (!(string.equals("referenceInfo") || string.equals("published") || string.equals("language") || string.equals("title"))) {
                return false;
            }
            if (this.overwrite || this.extraData.get(string) == null || this.extraData.get(string).equals("")) {
                this.extraData.put(string, string2);
                return true;
            }
        } else {
            if (string3.equals("KeyWords")) {
                if (!string.equals("keyword")) {
                    return false;
                }
                this.keyWords.add(string2);
                return true;
            }
            if (string3.equals("ExtIDs")) {
                if (!string.equals("extID")) {
                    return false;
                }
                this.extIDs.add(string2);
                return true;
            }
            if (string3.equals("Records") && (this.overwrite || this.records.get(string) == null)) {
                this.records.put(string, string2);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean load(Connection connection) {
        boolean bl;
        Statement statement = null;
        ResultSet resultSet = null;
        String string = "";
        try {
            boolean bl2;
            statement = connection.createStatement();
            Resource.debug("loading resource:" + this.id);
            string = "SELECT * FROM Resource WHERE id=" + DbTools.safeStr(this.id);
            Resource.debug(string);
            resultSet = statement.executeQuery(string);
            if (!resultSet.next()) {
                boolean bl3 = false;
                return bl3;
            }
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            bl = resultSetMetaData.getColumnCount();
            for (bl2 = true; bl2 <= bl; bl2 += 1) {
                String string2 = resultSetMetaData.getColumnName(bl2 ? 1 : 0);
                if (string2.equals("id") || string2.equals("type") || resultSet.getString(bl2 ? 1 : 0) == null) continue;
                Resource.debug("put data: " + string2 + ", " + resultSet.getString(bl2 ? 1 : 0));
                this.data.put(string2, resultSet.getString(bl2 ? 1 : 0));
            }
            string = "SELECT * FROM " + this.type + " WHERE id=" + DbTools.safeStr(this.id);
            Resource.debug(string);
            resultSet = statement.executeQuery(string);
            if (!resultSet.next()) {
                bl2 = false;
                return bl2;
            }
            resultSetMetaData = resultSet.getMetaData();
            bl = resultSetMetaData.getColumnCount();
            for (bl2 = true; bl2 <= bl; bl2 += 1) {
                if (resultSet.getString(bl2 ? 1 : 0) == null) continue;
                Resource.debug("put extraData: " + resultSetMetaData.getColumnName(bl2 ? 1 : 0) + ", " + resultSet.getString(bl2 ? 1 : 0));
                this.extraData.put(resultSetMetaData.getColumnName(bl2 ? 1 : 0), resultSet.getString(bl2 ? 1 : 0));
            }
            string = "SELECT * FROM Records WHERE resource=" + DbTools.safeStr(this.id);
            Resource.debug(string);
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                Resource.debug("put records: " + resultSet.getString("source") + "," + resultSet.getString("record") + "," + resultSet.getString("integrated"));
                this.records.put(resultSet.getString("source") + "\u00a4" + resultSet.getString("record"), resultSet.getString("integrated"));
            }
            string = "SELECT * FROM ExtIDs WHERE resource=" + DbTools.safeStr(this.id);
            Resource.debug(string);
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                Resource.debug("put extIDs:" + resultSet.getString("extID"));
                this.extIDs.add(resultSet.getString("extID"));
            }
            string = "SELECT * FROM KeyWords WHERE resource=" + DbTools.safeStr(this.id);
            resultSet = statement.executeQuery(string);
            Resource.debug(string);
            while (resultSet.next()) {
                Resource.debug("put keyWords:" + resultSet.getString("keyword"));
                this.keyWords.add(resultSet.getString("keyword"));
            }
            this.loaded = true;
            bl2 = true;
            return bl2;
        }
        catch (SQLException sQLException) {
            System.out.println("SQL ERROR (Resource.load): " + sQLException.getMessage());
            System.out.println("Previous query: " + string);
            bl = false;
            return bl;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save(Connection connection) {
        Statement statement = null;
        boolean bl = true;
        String string = "";
        try {
            String string2;
            String string3;
            bl = connection.getAutoCommit();
            connection.setAutoCommit(false);
            statement = connection.createStatement();
            if (this.loaded) {
                string3 = "UPDATE ";
                string2 = " WHERE id=" + DbTools.safeStr(this.id);
            } else {
                string3 = "INSERT INTO ";
                string2 = "";
            }
            Iterator iterator = this.data.entrySet().iterator();
            String string4 = "id=" + DbTools.safeStr(this.id) + ", type='" + this.type + "'";
            while (iterator.hasNext()) {
                Map.Entry object2 = iterator.next();
                string4 = string4 + "," + (String)object2.getKey() + "=" + DbTools.safeStr((String)object2.getValue());
            }
            string = string3 + "Resource SET " + string4 + string2;
            Resource.debug(string);
            statement.executeUpdate(string);
            iterator = this.extraData.entrySet().iterator();
            string4 = "id=" + DbTools.safeStr(this.id);
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                string4 = string4 + "," + (String)entry.getKey() + "=" + DbTools.safeStr((String)entry.getValue());
            }
            string = string3 + this.type + " SET " + string4 + string2;
            Resource.debug(string);
            statement.executeUpdate(string);
            if (this.loaded && this.records.size() > 0) {
                string = "DELETE FROM Records WHERE resource=" + DbTools.safeStr(this.id);
                Resource.debug(string);
                statement.executeUpdate(string);
            }
            for (Map.Entry entry : this.records.entrySet()) {
                String[] stringArray = ((String)entry.getKey()).split("\u00a4");
                string = "INSERT INTO Records SET resource=" + DbTools.safeStr(this.id) + ", source=" + DbTools.safeStr(stringArray[0]) + ", record=" + DbTools.safeStr(stringArray[1]) + ", integrated=" + DbTools.safeStr((String)entry.getValue());
                Resource.debug(string);
                statement.executeUpdate(string);
            }
            if (this.loaded && this.keyWords.size() > 0) {
                string = "DELETE FROM KeyWords WHERE resource=" + DbTools.safeStr(this.id);
                Resource.debug(string);
                statement.executeUpdate(string);
            }
            for (String string5 : this.keyWords) {
                string = "INSERT INTO KeyWords SET resource=" + DbTools.safeStr(this.id) + ", keyword=" + DbTools.safeStr(string5);
                Resource.debug(string);
                statement.executeUpdate(string);
            }
            if (this.loaded && this.extIDs.size() > 0) {
                string = "DELETE FROM ExtIDs WHERE resource=" + DbTools.safeStr(this.id);
                Resource.debug(string);
                statement.executeUpdate(string);
            }
            for (String string6 : this.extIDs) {
                string = "INSERT INTO ExtIDs SET resource=" + DbTools.safeStr(this.id) + ", extID=" + DbTools.safeStr(string6);
                Resource.debug(string);
                statement.executeUpdate(string);
            }
            connection.commit();
            boolean bl2 = true;
            return bl2;
        }
        catch (SQLException sQLException) {
            System.out.println("SQL ERROR-Resource.save(): " + sQLException.getMessage());
            System.out.println("Previous query: " + string);
            boolean bl3 = false;
            return bl3;
        }
        finally {
            try {
                connection.setAutoCommit(bl);
            }
            catch (SQLException sQLException) {}
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public String getSingleField(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(".");
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(0, n);
        string = string.substring(n + 1, string.length());
        if (string2.equals("Resource")) {
            return (String)this.data.get(string);
        }
        if (string2.equals("Role") || string2.equals("Actor") || string2.equals("Channel") || string2.equals("Document")) {
            return (String)this.extraData.get(string);
        }
        if (string2.equals("Records")) {
            return (String)this.records.get(string);
        }
        return null;
    }

    public HashSet getKeywords() {
        return (HashSet)this.keyWords.clone();
    }

    public HashSet getExtIDs() {
        return (HashSet)this.extIDs.clone();
    }

    public String getType() {
        return this.type;
    }

    public StringBuffer toHTML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<strong>Tunniste: </strong> ").append(this.id).append(" <strong>Nimi: </strong>").append(this.getSingleField("Resource.name")).append(" <strong>Kanonisoitu nimi: </strong>").append(this.getSingleField("Resource.canonicalName"));
        if (this.type.equals("Document")) {
            stringBuffer.append(" <strong>Viittaustieto: </strong>").append(this.getSingleField("Document.referenceInfo")).append(" <strong>Julkaistu: </strong>").append(this.getSingleField("Document.published")).append(" <strong>Kieli: </strong>").append(this.getSingleField("Document.language")).append(" <strong>Otsikko: </strong>").append(this.getSingleField("Document.title"));
        }
        if (this.type.equals("Actor")) {
            stringBuffer.append(" <strong>Tyyppi: </strong>").append(this.getSingleField("Actor.type"));
        }
        if (this.type.equals("Channel")) {
            stringBuffer.append(" <strong>Tyyppi: </strong>").append(this.getSingleField("Channel.type"));
        }
        if (this.type.equals("Role")) {
            stringBuffer.append(" <strong>Tyyppi: </strong>").append(this.getSingleField("Role.type"));
        }
        return stringBuffer;
    }

    private static void debug(String string) {
    }
}

