/*
 * Decompiled with CFR 0.152.
 */
package maito.resource;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import maito.resource.Resource;

public class ResourceLoader {
    private Connection connection;
    private ResultSet resources;
    private HashMap extIDs;
    private HashMap Records;
    private Statement stmt;

    public ResourceLoader(Connection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("ResourceLoader: no database connection provided");
        }
        this.connection = connection;
        this.resources = null;
        this.stmt = null;
    }

    public void executeSQL(String string) throws SQLException {
        this.stmt = this.connection.createStatement();
        this.resources = this.stmt.executeQuery(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Resource nextResource() throws SQLException {
        if (this.resources == null) {
            return null;
        }
        Resource resource = null;
        if (this.resources.next()) {
            String string = this.resources.getString("Resource.id");
            String string2 = this.resources.getString("Resource.type");
            if (string == null || string2 == null) {
                return null;
            }
            resource = new Resource(string, string2);
            if (resource.load(this.connection)) return resource;
        }
        this.resources.close();
        this.resources = null;
        this.stmt.close();
        return resource;
    }
}

