/*
 * Decompiled with CFR 0.152.
 */
package maito.util;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

public class DbTools {
    private DbTools() {
    }

    public static Connection createDbConnection(Properties properties) throws SQLException {
        String string = properties.getProperty("jdbc_driver");
        String string2 = properties.getProperty("jdbc_url");
        String string3 = properties.getProperty("jdbc_user");
        String string4 = properties.getProperty("jdbc_pass");
        String string5 = properties.getProperty("jdbc_conproperties");
        if (string5 == null) {
            string5 = "";
        }
        Connection connection = null;
        if (string == null || string2 == null || string3 == null || string4 == null) {
            throw new SQLException("connection parameters incomplete");
        }
        try {
            Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            throw new SQLException("Cannot load database driver: " + exception.getMessage());
        }
        string2 = string2 + "/" + string5;
        connection = DriverManager.getConnection(string2, string3, string4);
        return connection;
    }

    public static Connection createDbConnection(Properties properties, String string) throws SQLException {
        String string2 = properties.getProperty("jdbc_driver");
        String string3 = properties.getProperty("jdbc_url");
        String string4 = properties.getProperty("jdbc_user");
        String string5 = properties.getProperty("jdbc_pass");
        String string6 = properties.getProperty("jdbc_conproperties");
        if (string6 == null) {
            string6 = "";
        }
        Connection connection = null;
        if (string2 == null || string3 == null || string4 == null || string5 == null) {
            throw new SQLException("connection parameters incomplete");
        }
        if (string.length() > 0) {
            string = "/" + string;
        }
        try {
            Class.forName(string2).newInstance();
        }
        catch (Exception exception) {
            throw new SQLException("Cannot load database driver: " + exception.getMessage());
        }
        connection = DriverManager.getConnection(string3 + string + string6, string4, string5);
        return connection;
    }

    public static String escSQL(String string) {
        if (string == null) {
            return null;
        }
        return string.replaceAll("'", "\\\\'");
    }

    public static String safeStr(String string) {
        if (string == null) {
            return "NULL";
        }
        return "'" + string.replaceAll("'", "\\\\'") + "'";
    }

    public static String formatDate(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        return simpleDateFormat.format(date);
    }

    public static String SQLstr(String string, int n) {
        if (string == null) {
            string = "";
        } else if (!string.equals("")) {
            n = Math.max(n, 0);
            string = string.substring(0, Math.min(string.length(), n));
        }
        return "'" + DbTools.escSQL(string) + "'";
    }
}

