/*
 * Decompiled with CFR 0.152.
 */
package maito.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Properties;

public class Tools {
    public static final String PATH_DBCONFIG = "config" + File.separator + "dbconfig.properties";
    public static final String PATH_RESOURCEGRAPH_SQL = "config" + File.separator + "resourcegraph.sql";
    public static final String PATH_RAWDATA_SQL = "config" + File.separator + "rawdata.sql";
    public static final String RESOURCENET_PATH = "config" + File.separator + "resourcegraph.sql";
    public static final int ACTOR_CITESEER = 0;
    public static final int ACTOR_OTHER = 1;
    public static final String DATASOURCE_PARAM_LOCATION = "location";
    public static final String DATASOURCE_PARAM_UPDATED = "updated";
    private static final String[] ORGKEYWORDS = new String[]{" INC", " LTD", " OF ", " CO.", " CORP", " PRESS", " UNIV", " PUBL"};
    private static final String[] PERSONKEYWORDS = new String[]{" ED.", " EDS.", "ET AL.", "ET ALII.", " ANON.", " JR.", " SR."};

    private Tools() {
    }

    public static String canonizeGeneric(String string) {
        if (string != null) {
            String string2 = string.trim();
            string2 = string2.replaceAll("\\s+", " ");
            string2 = string2.replaceAll("[\\W&&[^\\,\\.\\/\\-\\:\\~ ]]", "");
            string2 = string2.toUpperCase();
            return string2;
        }
        return null;
    }

    public static String[] canonizeActor(String string, int n) {
        int n2;
        if (string == null) {
            return null;
        }
        String string2 = "Joku";
        if (string.indexOf("://") != -1 || string.indexOf("www.") != -1) {
            string2 = "Joku";
            String[] stringArray = new String[]{string2, string};
            return stringArray;
        }
        Object object = Tools.canonizeGeneric(string);
        for (n2 = 0; n2 < ORGKEYWORDS.length; ++n2) {
            if (((String)object).indexOf(ORGKEYWORDS[n2]) == -1) continue;
            string2 = "Organisaatio";
            String[] stringArray = new String[]{string2, object};
            return stringArray;
        }
        if (((String)object).matches(".* [A-Z]\\..*")) {
            string2 = "Henkil\u00f6";
        } else {
            for (n2 = 0; n2 < PERSONKEYWORDS.length; ++n2) {
                if (((String)object).indexOf(PERSONKEYWORDS[n2]) == -1) continue;
                object = ((String)object).replaceAll(PERSONKEYWORDS[n2], "").trim();
                string2 = "Henkil\u00f6";
            }
        }
        if (string2.equals("Henkil\u00f6")) {
            if (n == 0) {
                String[] stringArray = ((String)object).split(",");
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = stringArray[i].trim();
                    int n3 = stringArray[i].lastIndexOf(" ");
                    if (n3 == -1) continue;
                    String string3 = stringArray[i].substring(n3 + 1, stringArray[i].length());
                    stringArray[i] = string3 = string3 + ", " + stringArray[i].substring(0, 1);
                }
                String[] stringArray2 = new String[stringArray.length + 1];
                stringArray2[0] = string2;
                for (int i = 1; i < stringArray2.length; ++i) {
                    stringArray2[i] = stringArray[i - 1];
                }
                return stringArray2;
            }
            n2 = ((String)object).indexOf(", ");
            if (n2 != -1) {
                object = ((String)object).substring(0, n2 + 3);
                String[] stringArray = new String[]{string2, object};
                return stringArray;
            }
            n2 = ((String)object).indexOf(" ");
            if (n2 != -1) {
                String string4 = ((String)object).substring(0, n2) + ", " + ((String)object).substring(n2 + 1, n2 + 2);
                String[] stringArray = new String[]{string2, string4};
                return stringArray;
            }
            String[] stringArray = new String[]{string2, object};
            return stringArray;
        }
        string = Tools.canonizeGeneric(string);
        object = new String[]{string2, string};
        return object;
    }

    public static String canonizeDate(String string) {
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() < 10) {
            return null;
        }
        String string2 = string.substring(0, 10);
        if (string2.matches("\\d{4}-\\d{2}-\\d{2}")) {
            return string2;
        }
        return null;
    }

    public static String canonizeLang(String string) {
        if (string == null) {
            return null;
        }
        String string2 = Tools.canonizeGeneric(string);
        String[] stringArray = string2.split("-");
        if (stringArray[0].matches("[A-Z]{2,3}")) {
            return stringArray[0];
        }
        return null;
    }

    public static String canonizeTitle(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.replaceAll("(\\s+|\\G|^)\\S{0,3}(\\s+|$)", " ");
        string2 = Tools.canonizeGeneric(string2);
        return string2;
    }

    public static String categorizeIdentifier(String string) {
        if (string == null) {
            return null;
        }
        String string2 = "Sis\u00e4inenTunniste";
        String string3 = string.toLowerCase().trim();
        if (string3.startsWith("http")) {
            string2 = "URLTunniste";
        } else if (string3.startsWith("urn")) {
            string2 = "URNTunniste";
        } else if (string3.startsWith("info:oai")) {
            string2 = "OAITunniste";
        } else if (string3.startsWith("info:ofi")) {
            string2 = "OpenURLTunniste";
        } else if (string3.startsWith("info:doi")) {
            string2 = "DOITunniste";
        } else if (string3.startsWith("info")) {
            string2 = "INFOTunniste";
        } else if (string3.length() > 16) {
            if (string3.matches("(.*(\\.|,)+.*){2,}")) {
                String string4 = string3.substring(0, 4);
                String string5 = string3.substring(string3.length() - 4);
                if (string4.matches("(1[8-9]\\d{2})|(20[0-1]\\d)") || string5.matches("(1[8-9]\\d{2})|(20[0-1]\\d)")) {
                    string2 = "ViittausTunniste";
                }
            }
        } else if (string3.indexOf("://") != -1) {
            string2 = "URITunniste";
        }
        return string2;
    }

    public static String[] splitActor(String string, int n) {
        if (string == null) {
            return null;
        }
        String string2 = Tools.determineActorType(string);
        if (string2.equals("Henkil\u00f6") && n == 0) {
            return Tools.splitPerson(string);
        }
        String[] stringArray = new String[]{string2, string};
        return stringArray;
    }

    private static String determineActorType(String string) {
        String string2 = "Joku";
        if (string.indexOf("://") == -1 && string.indexOf("www.") == -1) {
            int n;
            String string3 = Tools.canonizeGeneric(string);
            for (n = 0; n < ORGKEYWORDS.length; ++n) {
                if (string3.indexOf(ORGKEYWORDS[n]) == -1) continue;
                string2 = "Organisaatio";
                return string2;
            }
            if (string3.matches(".* [A-Z]\\..*")) {
                string2 = "Henkil\u00f6";
            } else {
                for (n = 0; n < PERSONKEYWORDS.length; ++n) {
                    if (string3.indexOf(PERSONKEYWORDS[n]) == -1) continue;
                    string2 = "Henkil\u00f6";
                    return string2;
                }
            }
        }
        return string2;
    }

    public static String[] splitPerson(String string) {
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split(",");
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = "Henkil\u00f6";
        for (int i = 1; i < stringArray2.length; ++i) {
            stringArray2[i] = stringArray[i - 1];
        }
        return stringArray2;
    }

    public static String readFile(String string) {
        try {
            File file = new File(string);
            if (!file.isFile()) {
                return null;
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            char[] cArray = new char[(int)file.length()];
            bufferedReader.read(cArray, 0, (int)file.length());
            String string2 = new String(cArray);
            bufferedReader.close();
            file = null;
            return string2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean saveFile(String string, String string2, boolean bl) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string, bl), "UTF-8"));
            bufferedWriter.write(string2);
            bufferedWriter.close();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static Properties loadProperties(String string) {
        try {
            Properties properties = new Properties();
            properties.load(new FileInputStream(new File(string)));
            return properties;
        }
        catch (Exception exception) {
            System.out.println("ERROR in Tools.loadProperties: " + exception);
            return null;
        }
    }
}

