create table DataSource (
	id VARCHAR(100) NOT NULL,
	format ENUM('dcxml','quick_format_name','quick_format_document','oai_citeseer','unknown'),
	location VARCHAR(255) NOT NULL,
	lineCount BIGINT UNSIGNED,
	updated DATE,
	modified DATE,
	PRIMARY KEY(id)
	) DEFAULT CHARACTER SET utf8 ENGINE=InnoDB;

create table DataRecord (
	id VARCHAR(200) NOT NULL,
	source VARCHAR(100) NOT NULL,
	firstLineNumber BIGINT UNSIGNED,
	lastLineNumber BIGINT UNSIGNED,
	integratedTo TEXT,
	PRIMARY KEY(id, source),
	FOREIGN KEY(source) references DataSource(id) ON DELETE CASCADE,
	INDEX (source)
	) DEFAULT CHARACTER SET utf8 ENGINE=InnoDB;
	
create table Statement (
	id BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
	name VARCHAR(255) NOT NULL,
	value VARCHAR(255) NOT NULL,
	record VARCHAR(200) NOT NULL,
	source VARCHAR(100) NOT NULL,
	PRIMARY KEY(id),
	FOREIGN KEY(record, source) references DataRecord(id, source) ON DELETE CASCADE,
	INDEX (record, source)
	) DEFAULT CHARACTER SET utf8 ENGINE=InnoDB;
	