create table Resource (
  id VARCHAR(100) NOT NULL, 
  name VARCHAR(255) NOT NULL DEFAULT '',
  canonicalName VARCHAR(255) NOT NULL DEFAULT '',
  created DATE,
  type ENUM('Actor', 'Document', 'Channel', 'Role'),
  PRIMARY KEY(id),
  INDEX(canonicalName)
  ) DEFAULT CHARACTER SET utf8 ENGINE=InnoDB;

create table ExtIDs (
  resource VARCHAR(100) NOT NULL,
  extID VARCHAR(255) NOT NULL,
  FOREIGN KEY(resource) references Resource(id) ON DELETE CASCADE,
  INDEX(extID),
  INDEX(resource)
  ) DEFAULT CHARACTER SET utf8 ENGINE=InnoDB;

create table KeyWords (
  resource VARCHAR(100) NOT NULL,
  keyword VARCHAR(255) NOT NULL,
  FOREIGN KEY(resource) references Resource(id) ON DELETE CASCADE,
  INDEX(keyword),
  INDEX(resource)
  ) DEFAULT CHARACTER SET utf8 ENGINE=InnoDB;

create table Records (
  resource VARCHAR(100) NOT NULL,
  record VARCHAR(200) NOT NULL,
  source VARCHAR(100) NOT NULL,
  integrated DATE,
  FOREIGN KEY(resource) references Resource(id) ON DELETE CASCADE,
  INDEX(resource),
  INDEX(record),
  INDEX(source)
  ) DEFAULT CHARACTER SET utf8 ENGINE=InnoDB;
  
create table DataSources (
  sourceID VARCHAR(100) NOT NULL,
  integrated DATE,
  PRIMARY KEY(sourceID),
  INDEX(sourceID)
  ) DEFAULT CHARACTER SET utf8 ENGINE=InnoDB;

create table Actor (
  id VARCHAR(100) NOT NULL,
  type ENUM('Henkilö', 'Organisaatio', 'Joku'),
  PRIMARY KEY(id),
  FOREIGN KEY(id) references Resource(id) ON DELETE CASCADE,
  INDEX(type)
  ) DEFAULT CHARACTER SET utf8 ENGINE=InnoDB;

create table Role (
  id VARCHAR(100) NOT NULL,
  type ENUM('Tekijä', 'Julkaisija', 'Avustaja', 'Oikeuksienomistaja', 'Hallinnoija', 'Joku'),
  PRIMARY KEY(id),
  FOREIGN KEY(id) references Resource(id) ON DELETE CASCADE,
  INDEX(type)
  ) DEFAULT CHARACTER SET utf8 ENGINE=InnoDB;

create table Document (
  id VARCHAR(100) NOT NULL,
  referenceInfo TEXT,
  published DATE,
  language VARCHAR(3),
  title TEXT,
  PRIMARY KEY(id),
  FOREIGN KEY(id) references Resource(id) ON DELETE CASCADE,
  INDEX(language)
  ) DEFAULT CHARACTER SET utf8 ENGINE=InnoDB;

create table Channel (
  id VARCHAR(100) NOT NULL,
  type ENUM('Lehti', 'Konferenssi', 'Julkaisusarja', 'Raporttisarja', 'Tietokanta', 'Joku'),
  PRIMARY KEY(id),
  FOREIGN KEY(id) references Resource(id) ON DELETE CASCADE,
  INDEX(type)
  ) DEFAULT CHARACTER SET utf8 ENGINE=InnoDB;
  
create table ResourceRelation (
  role VARCHAR(100) NOT NULL,
  subject VARCHAR(100) NOT NULL,
  object VARCHAR(100) NOT NULL,
  PRIMARY KEY(subject, role, object),
  FOREIGN KEY(subject) references Resource(id) ON DELETE CASCADE,
  FOREIGN KEY(role) references Role(id) ON DELETE CASCADE,
  FOREIGN KEY(object) references Resource(id) ON DELETE CASCADE,
  INDEX(subject),
  INDEX(object),
  INDEX(role)
  ) DEFAULT CHARACTER SET utf8 ENGINE=InnoDB;
  
create table MeaningType (
  id INTEGER NOT NULL AUTO_INCREMENT,
  name VARCHAR(255) NOT NULL,
  PRIMARY KEY(id),
  INDEX(name)
  ) DEFAULT CHARACTER SET utf8 ENGINE=InnoDB;

create table Meaning (
  id VARCHAR(100) NOT NULL,
  type INTEGER NOT NULL,
  resource1 VARCHAR(100) NOT NULL,
  resource2 VARCHAR(100),
  collectionID VARCHAR(100),
  value FLOAT,
  PRIMARY KEY(id),
  FOREIGN KEY(resource1) references Resource(id) ON DELETE CASCADE,
  FOREIGN KEY(resource2) references Resource(id) ON DELETE CASCADE,
  FOREIGN KEY(type) references MeaningType(id) ON DELETE CASCADE,
  INDEX(resource1),
  INDEX(resource2),
  INDEX(type)
  ) DEFAULT CHARACTER SET utf8 ENGINE=InnoDB;

INSERT INTO Resource SET id='NONE', name='SPECIAL: Channel to Document relation', canonicalName='', type='Role';
INSERT INTO Role SET id='NONE';
INSERT INTO Resource SET id='BIBREF', name='SPECIAL: Document to Document relation', canonicalName='', type='Role';
INSERT INTO Role SET id='BIBREF';
