package maito;

/**
 * A common interface for subsystems that process data in some way.
 * @author Antti Laitinen
 *
 */
public interface DataProcessor {

    /**
     * Tells whether this DataProcessor is currently processing data.
     * @return
     * true if data is being processed, otherwise false.
     */
    public boolean workInProgress();
    
    /**
     * Returns a user readable description of every task that is in progress at the moment.
     * @return
     * An array of String objects containing the description of each task. If no tasks are in progress returns an empty array.
     */
    public String[] getCurrentTasks();
    
    /**
     * Returns all errors that have occurred since the last data processing was started. The errors are in a user readable form.   
     * @return
     * An array of String objects where each String is a description of the error. If no errors have occurred the array is empty.
     */
    public String[] getErrors();
    
    /**
     * Sets a listener for all log messages sent by this DataProcessor.
     *
     * @param listener
     * The object that listens to this DataProcessor's log messages.
     */
     public void setLogListener(LogListener listener);
}
