package maito.browsing.fileexport;

import maito.resource.Resource;
import maito.resource.ResourceRelation;

public interface FileExporter {
    
    /**
     * 
     * @param filename 
     * Name of the file to be written
     * @param format
     * Format of the file to be written - use getFormats() to find out which ones it supports
     * @param resources
     * Resources to be saved to the file
     * @param relations
     * Relations to be saved to the file
     * @return
     * true if save succeeded, false if there was an error
     */
    public boolean writeFile (String filename, String format, Resource[] resources, ResourceRelation[] relations);
    
    /**
     * Gets a list of file export formats that are supported by the software.
     * @return
     * Identifiers of export formats that the software currently supports.
     */
    public String[] getFormats();

}
