package maito.browsing.fileexport;

import maito.resource.Resource;
import maito.resource.ResourceRelation;

public interface FileFormat {
    
    /**
     * Sets the resources that are to be written to the file.
     * @param resources
     * The resources that are to be written to the file. The implementing method
     * should replace the possibly previously set resources instead of adding
     * new ones to the previous array.
     */
    public void setResources (Resource[] resources);

    /**
     * Sets the relations that are to be written to the file.
     * @param relations
     * The relations that are to be written to the file. The implementing method
     * should replace the possibly previously set relations instead of adding
     * new ones to the previous array.
     */
    public void setRelations (ResourceRelation[] relations); 
    
    /**
     * Writes the data set by setResources and setRelations to a file
     * that's in a format that the implementing class supports.
     * @param filename 
     * the full path and name of the file to write the data to
     * @return 
     * true if succeeded, false if there was an error
     */
    public boolean writeFile (String filename);
        
}
