/*
 * MainWindow.java
 *
 * Created on 5. joulukuuta 2005, 12:56
 */

package maito.browsing.gui;


import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.text.JTextComponent;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import java.io.*;
import javax.xml.parsers.*;
import maito.browsing.ResourceBrowser;
import maito.resource.Resource;
import maito.util.XMLTools;
import java.sql.SQLException;
import java.util.Vector;


/**
 * A class that can be used as user interface for the class ResourceBrowser. 
 * 
 * @author  Juuso Vanonen
 */
public class MainWindow extends JFrame implements Runnable {

    // Variables declaration 
   
    private JPanel resourceGraphPanel;
    private JPanel sqlPanel;
    private JPanel fixedQueryPanel;
    private JPanel queryPanel;
    private JPanel resourcePanel;
    private TitledBorder resourcePanelBorder;
    private JPanel exportPanel;
    private JPanel fileFormatPanel;
    private JPanel pageSelectorPanel;
    
    private JTextArea queryArea;
    private JScrollPane queryScrollPanel;
    
    private JEditorPane documentsHTMLPanel;
    private JScrollPane documentsPanel;
       
    private JEditorPane actorsHTMLPanel;
    private JScrollPane actorsPanel;
    
    private JEditorPane channelsHTMLPanel;
    private JScrollPane channelsPanel;
    
    private JEditorPane rolesHTMLPanel;
    private JScrollPane rolesPanel;
        
    private JButton queryProcessButton;
    private JButton saveFileButton;
    private JButton nextPageButton;
    private JButton previousPageButton;

    private JComboBox graphSelectCombo;
    private JComboBox fixedQueryCombo;
    private JComboBox fileFormatCombo;
    
    private JLabel graphSelectLabel;
    private JLabel fixedQueryLabel;
    private JLabel fileFormatLabel;
    
    private JFileChooser fileChooser;
    // End of gui-componets
    
    
    private ResourceBrowser browser;
    private DocumentBuilderFactory factory; 
    private DocumentBuilder builder;
 
    private File exampleQueriesFile;

    private String[] exampleQueries;
    private String[] exampleQueryNames;

    private final int WINDOW_WIDTH = 800;
    private final int WINDOW_HEIGHT = 600;
    private final String EXAMPLEQUERIES_PATH = "config";
    private final String EXAMPLEQUERIES_FILE = "queries.xml";

    
    private boolean updatingView;
    
    private final String RESOURCE_PANEL_TITLE_NORMAL = "Resources";
    private final String RESOURCE_PANEL_TITLE_PROCESSING = "Fetching resources...";
    private final String RESOURCE_PANEL_TITLE_FORMINGVIEW = "Forming resource views...";
    
    private final int PAGE_SIZE = 200;
    
    private int currentPage;
    
    private int pageCount;
    
    private Vector documentsPages;
    private Vector actorsPages;
    private Vector channelsPages;
    private Vector rolesPages;
    
    
    /** Creates new JFrame-object */
    
    public MainWindow(){
    	browser = new ResourceBrowser();
        this.getExampleQueries();
    	initComponents();
        this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        //this.setBounds(0, 0, this.WINDOW_WIDTH, this.WINDOW_HEIGHT);
        this.setVisible(true);
        /*this.getExampleQueries();*/
        updatingView = false;
        
        documentsPages = new Vector();
        actorsPages = new Vector();
        channelsPages = new Vector();
        rolesPages = new Vector();
        
        currentPage = 0;
        pageCount = 0;
    }
      
    /** Initializes the components of GUI
     * 
     */
    private void initComponents() {
        
        /* Initialize the frame */
        getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints constraint = new GridBagConstraints();
        constraint.fill = GridBagConstraints.HORIZONTAL;
        setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);
        setTitle("Resource Browser");

        
        /** Initialize resourceGraphPanel
         * owns:
         *   - graphSelectLabel
         *   - graphSelectCombo */
         
        resourceGraphPanel = new JPanel();
        resourceGraphPanel.setLayout(new BoxLayout(resourceGraphPanel, BoxLayout.X_AXIS));
        resourceGraphPanel.setMaximumSize(new Dimension(32767, 30));
        
        /* Initialize the graphSelectLabel */
        graphSelectLabel = new JLabel();
        graphSelectLabel.setHorizontalAlignment(SwingConstants.LEFT);
        graphSelectLabel.setText("Select Resource Graph:");
        
        /* Initialize the graphSelectCombo */
        String[] graphNames = this.browser.getGraphs();
        if (graphNames == null) {
            JOptionPane.showMessageDialog(this,
                    "Could not find resource graphs",
                    "Configuration Error",
                    JOptionPane.ERROR_MESSAGE);
    
        }
        graphSelectCombo = new JComboBox(graphNames);

        /* Add the objects */
        resourceGraphPanel.add(graphSelectLabel);
        resourceGraphPanel.add(Box.createRigidArea(new Dimension(3,0)));
        resourceGraphPanel.add(graphSelectCombo);
        constraint.gridx = 0;
        constraint.gridy = 0;
        constraint.weighty = 1.0;
        constraint.weightx = 1.0;
        getContentPane().add(resourceGraphPanel, constraint);

        
        /** Initialize the SQL-panel 
        * owns:                     
        *    - fixedQueryPanel      
        *    - queryPanel */            
        
        sqlPanel = new JPanel();
        sqlPanel.setLayout(new GridBagLayout());
        GridBagConstraints sqlConstraint = new GridBagConstraints();
        sqlConstraint.fill = GridBagConstraints.HORIZONTAL;
        sqlPanel.setBorder(new TitledBorder(null, "SQL", TitledBorder.DEFAULT_JUSTIFICATION, TitledBorder.DEFAULT_POSITION, new java.awt.Font("Tahoma", 0, 14)));
        sqlPanel.setAlignmentY(0.0F);
        sqlPanel.setAutoscrolls(true);

        
        /** Initialize the fixedQueryPanel in SQL-panel 
         * owns:
         *      - fixedQueryLabel
         *      - fixedQueryCombo       */
         
        fixedQueryPanel = new JPanel();
        fixedQueryPanel.setLayout(new BoxLayout(fixedQueryPanel, BoxLayout.X_AXIS));
        
        /* Initialize the fixedQueryLabel */
        fixedQueryLabel = new JLabel();
        fixedQueryLabel.setHorizontalAlignment(SwingConstants.LEFT);
        fixedQueryLabel.setText("Select SQL-example:");
        
        /* Initialize the fixedQueryCombo */
        fixedQueryCombo = new JComboBox(this.exampleQueryNames);
        fixedQueryCombo.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                fixedQueryComboActionPerformed(evt);
            }
        });
        
        /* Add the components */        
        fixedQueryPanel.add(fixedQueryLabel);
        fixedQueryPanel.add(Box.createRigidArea(new Dimension(3,0)));
        fixedQueryPanel.add(fixedQueryCombo);
        

        /** Initialize the query-panel in SQL-panel
         * Owns:
         *      - queryScrollPanel & queryArea
         *      - queryProcessButton */
                 
        queryPanel = new JPanel();
        queryPanel.setLayout(new BoxLayout(queryPanel, BoxLayout.X_AXIS));
        queryPanel.setBorder(new TitledBorder("Query"));
               
        /* Initialize queryArea & queryScrollPanel */
        queryArea = new JTextArea();
        queryArea.setLineWrap(true);
        queryScrollPanel = createResultPanel(queryArea, null);
        queryArea.setBorder(new EtchedBorder());
        
        /* Initialize queryProcessButton */
        queryProcessButton = new JButton();
        queryProcessButton.setText("Process");
        queryProcessButton.setActionCommand("jButton1");
        queryProcessButton.addMouseListener(new MouseAdapter() {
            public void mouseClicked(MouseEvent evt) {
                queryProcessButtonMouseClicked(evt);
            }
        });
        
        /* Initialize nextPageButton */
        nextPageButton = new JButton();
        nextPageButton.setText("next page");
        nextPageButton.setActionCommand("jButton1");
        nextPageButton.addMouseListener(new MouseAdapter() {
            public void mouseClicked(MouseEvent evt) {
                nextPage(evt);
            }
        });
        
        /* Initialize previousPageButton */
        previousPageButton = new JButton();
        previousPageButton.setText("previous page");
        previousPageButton.setActionCommand("jButton1");
        previousPageButton.addMouseListener(new MouseAdapter() {
            public void mouseClicked(MouseEvent evt) {
                previousPage(evt);
            }
        });
        
        
        /* Add the components */
        queryPanel.add(queryScrollPanel);
        queryPanel.add(queryProcessButton);
        
        sqlConstraint.gridy = 0;
        sqlConstraint.gridx = 0;
        sqlConstraint.weightx = 1.0;
        sqlConstraint.weighty = 1.0;
        sqlPanel.add(fixedQueryPanel, sqlConstraint);
        
        sqlConstraint.gridy = 1;
        sqlConstraint.ipadx = 50;
        sqlConstraint.ipady = 20;
        sqlConstraint.weighty = 2.0;
        sqlPanel.add(queryPanel, sqlConstraint);
                
        constraint.gridx = 0;
        constraint.gridy = 1;
        constraint.ipady = 40;
        getContentPane().add(sqlPanel, constraint);       

        
        /** Initialize the resourcepanels 
         * Contains:
         *      - documentsPanel
         *      - actorsPanel
         *      - channelsPanel
         *      - rolesPanel */
                 
        resourcePanel = new JPanel();
        resourcePanel.setLayout(new GridLayout(2, 2));
        this.resourcePanelBorder = new TitledBorder(null, RESOURCE_PANEL_TITLE_NORMAL, TitledBorder.DEFAULT_JUSTIFICATION, TitledBorder.DEFAULT_POSITION, new java.awt.Font("Tahoma", 0, 14)); 
        resourcePanel.setBorder(this.resourcePanelBorder);                

        documentsHTMLPanel = new JEditorPane();
        documentsHTMLPanel.setEditable(false);
        documentsHTMLPanel.setContentType("text/html");        
        this.documentsPanel = this.createResultPanel(documentsHTMLPanel, "Documets");
        
        /* Initialize the actorsPanel */
        actorsHTMLPanel = new JEditorPane();
        actorsHTMLPanel.setEditable(false);
        actorsHTMLPanel.setContentType("text/html");        
        this.actorsPanel = this.createResultPanel(actorsHTMLPanel, "Actors");

        /* Initialize the ChannelsPanel */
        channelsHTMLPanel = new JEditorPane();
        channelsHTMLPanel.setEditable(false);
        channelsHTMLPanel.setContentType("text/html");        
        this.channelsPanel = this.createResultPanel(channelsHTMLPanel, "Channels");

        /* Initialize the rolesPanel */
        rolesHTMLPanel = new JEditorPane();
        rolesHTMLPanel.setEditable(false);
        rolesHTMLPanel.setContentType("text/html");
        this.rolesPanel = this.createResultPanel(rolesHTMLPanel, "Roles");

        /*Add Components */
        resourcePanel.add(documentsPanel);
        resourcePanel.add(actorsPanel);        
        resourcePanel.add(channelsPanel); 
        resourcePanel.add(rolesPanel);
        constraint.gridx = 0;
        constraint.gridy = 2;
        constraint.weighty = 2.0;
        constraint.ipady = 350;
        getContentPane().add(resourcePanel, constraint);
        
        pageSelectorPanel = new JPanel();
        pageSelectorPanel.setLayout(new GridLayout(1,2));
        pageSelectorPanel.add(previousPageButton);
        pageSelectorPanel.add(nextPageButton);
        constraint.gridx = 0;
        constraint.gridy = 3;
        constraint.weighty = 0;
        constraint.ipady = 0;
        getContentPane().add(pageSelectorPanel, constraint);
        
        
        /** Initialize the file export panel
         * Contains:
         *      - saveFileButton
         *      - fileChooser dialog
         *      - fileFormatLabel
         *      - fileFormatCombo */
         
        exportPanel = new JPanel();
        exportPanel.setLayout(new BoxLayout(exportPanel, BoxLayout.X_AXIS));
        
        /* Initialize the savefile-button */
        saveFileButton = new JButton();
        saveFileButton.setText("Save file");
        saveFileButton.addMouseListener(new MouseAdapter() {
            public void mouseClicked(MouseEvent evt) {
                saveFileButtonMouseClicked(evt);
            }
            });
                
        /* Initialize the fileChooser dialog */
        fileChooser = new JFileChooser();

        /* Initialize the fileFormatPanel */
        fileFormatPanel = new JPanel();
        fileFormatPanel.setLayout(new BoxLayout(fileFormatPanel, BoxLayout.Y_AXIS));

        /* Initialize the fileFormatLabel */
        fileFormatLabel = new JLabel();
        fileFormatLabel.setHorizontalAlignment(SwingConstants.LEFT);
        fileFormatLabel.setText("File Format:");
   
        /* Initialize the fileFormatCombo */
        fileFormatCombo = new JComboBox(browser.getFileFormats());
        fileFormatCombo.setMaximumSize(new Dimension(327, 327));
        
        /*Add Components */
        exportPanel.add(saveFileButton);
        exportPanel.add(Box.createRigidArea(new Dimension(50,0)));
        exportPanel.add(fileFormatLabel);
        exportPanel.add(Box.createRigidArea(new Dimension(3,0)));
        exportPanel.add(fileFormatCombo);  
        constraint.gridx = 0;
        constraint.gridy = 4;
        constraint.weighty = 1.0;
        constraint.ipady = 0;
        getContentPane().add(exportPanel, constraint);

            
        pack();
    }
    
    
    /**
     * Initializes the example queries ComboBox. Reads the XML-file queries.xml and   
     * fetches the tags: menutext and sql
     * Initializes the queryNamesCombo-object.
     */
    private void getExampleQueries() {
         this.exampleQueriesFile = new File(EXAMPLEQUERIES_PATH + File.separator + EXAMPLEQUERIES_FILE);
         if (!this.exampleQueriesFile.exists()){
             JOptionPane.showMessageDialog(this,
                     "Could not find configuration file 'queries.xml'",
                     "Configuration Error",
                     JOptionPane.ERROR_MESSAGE);   
         }    
         this.factory = DocumentBuilderFactory.newInstance();
         this.factory.setNamespaceAware(true);
         try {
         this.builder = factory.newDocumentBuilder();
             }
          catch(Exception e) {
              //TODO handling code
          }
          int queryTableIndex = 0;
          try {
          while (XMLTools.getNodeContent(builder, new FileInputStream(exampleQueriesFile), "examplequeries/query[" + (queryTableIndex+1) + "]/menutext") != null &&
        		  	XMLTools.getNodeContent(builder, new FileInputStream(exampleQueriesFile), "examplequeries/query[" + (queryTableIndex+1) + "]/sql") != null) {
        	  queryTableIndex++;
          }                                           
          this.exampleQueries = new String[queryTableIndex];
          this.exampleQueryNames = new String[queryTableIndex];
          
          for (int i=0; i<queryTableIndex; i++) {
        	  this.exampleQueries[i] = XMLTools.getNodeContent(builder, new FileInputStream(exampleQueriesFile), "examplequeries/query[" + (i+1) + "]/sql");
        	  this.exampleQueryNames[i] = XMLTools.getNodeContent(builder,  new FileInputStream(exampleQueriesFile), "examplequeries/query[" + (i+1) + "]/menutext");        	  
          }
          } catch (Exception e) {
              JOptionPane.showMessageDialog(this,
                    "Error reading configuration file 'queries.xml'",
                    "Configuration Error",
                    JOptionPane.ERROR_MESSAGE);
          };    
     }
    
    /**
     * Creates JScrollPane from JTextComponens. That is gives scrollbars to text-components.  
     * @param component
     * The text component
     * @param title
     * The title of the text component or null
     * @return
     * Panel that has scrollbars
     */
      private JScrollPane createResultPanel(JTextComponent component, String title) {
          JScrollPane scrollPane = new JScrollPane(component);
          scrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
          if (title != null) {
        	  scrollPane.setBorder(BorderFactory.createTitledBorder(title));
          }
          return scrollPane;
      }
      
      
      /**
       * Reacts to the click of query process button. 
       * Sends query to ResourceBrowser and get html representation of 
       * the resources to resource text areas.  
       */ 

      private void queryProcessButtonMouseClicked(MouseEvent evt) {//GEN-FIRST:event_queryProcessButtonMouseClicked

          if(!this.updatingView) {
          
              this.updatingView = true;
              
              try {
              this.browser.executeSQL(queryArea.getText(), (String)graphSelectCombo.getSelectedItem());
              }
              catch (Exception e) {
                	JOptionPane.showMessageDialog(this,
                		    e.getMessage(),
                		    "SQL Error",
                		    JOptionPane.ERROR_MESSAGE);
                    this.updatingView = false;
                	return;
              }
                
              new Thread(this).start();
          }
    }
      
      /**
       * Reacts to the click of save file button. 
       * Opens file browser where user can save the file.  
       * Sends the information of the file to resource browser.  
       */ 
    private void saveFileButtonMouseClicked(MouseEvent evt) {
        if(!this.updatingView) {
        	String filePath;
        	String fileFormat;
            int overwrite = 0;
        	int returnVal = this.fileChooser.showSaveDialog(MainWindow.this);
            if (returnVal == JFileChooser.APPROVE_OPTION) {
                if (this.fileChooser.getSelectedFile().exists()) {
                    overwrite = JOptionPane.showConfirmDialog(
                            this,
                            "File exist. Do you wan't to overwrite?",
                            "File exists!",
                            JOptionPane.YES_NO_OPTION);
                }
                if (overwrite == 1) {
                    return; 
                }
            }
            filePath = this.fileChooser.getSelectedFile().getAbsolutePath();
            fileFormat = (String)this.fileFormatCombo.getSelectedItem();
            this.browser.writeToFile(filePath, fileFormat);
        }
    }
    

    /**
     * Reacts to the change in fixedQueryCombo. 
     * Brings the selected example SQL-query to query-textarea 
     */
    private void fixedQueryComboActionPerformed(ActionEvent evt) {
    	int index = this.fixedQueryCombo.getSelectedIndex();
    	this.queryArea.setText(this.exampleQueries[index]);
    }
    
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        JFrame.setDefaultLookAndFeelDecorated(true);
        new MainWindow();
    }  
    
    public void run() {
        this.documentsPages.clear();
        this.actorsPages.clear();
        this.channelsPages.clear();
        this.rolesPages.clear();
        this.documentsPanel.setBorder(new TitledBorder("Documents"));
        this.actorsPanel.setBorder(new TitledBorder("Actors"));
        this.channelsPanel.setBorder(new TitledBorder("Channels"));
        this.rolesPanel.setBorder(new TitledBorder("Roles"));
        
        this.resourcePanelBorder.setTitle(RESOURCE_PANEL_TITLE_PROCESSING);
        this.resourcePanel.repaint();
        
        documentsHTMLPanel.setText("no resources");
        actorsHTMLPanel.setText("no resources");
        channelsHTMLPanel.setText("no resources");
        rolesHTMLPanel.setText("no resources");
        
        Resource resource = null;
        
        long resourceCount = 0;
        long documentCount = 0;
        long actorCount = 0;
        long channelCount = 0;
        long roleCount = 0;
        
        
        
        try {
           resource = this.browser.nextResource();
           resourceCount++;
        }
        catch(SQLException e) {
            JOptionPane.showMessageDialog(this,
                    e.getMessage(),
                    "Unsupported query",
                    JOptionPane.ERROR_MESSAGE);
        }
        
        StringBuffer documentsHTML = new StringBuffer("<html><body><table border=\"1\" width=\"100%\">");
        StringBuffer actorsHTML = new StringBuffer("<html><body><table border=\"1\" width=\"100%\">");
        StringBuffer channelsHTML = new StringBuffer("<html><body><table border=\"1\" width=\"100%\">");
        StringBuffer rolesHTML = new StringBuffer("<html><body><table border=\"1\" width=\"100%\">");

        pageCount = 1;
        this.currentPage = 0;
        
        while(resource != null) {
            
            if (resource.getType().equalsIgnoreCase("Document")) {
                documentsHTML.append("<tr><td>").append(resource.toHTML()).append("</td></tr>");
                documentCount++;
            }
            if (resource.getType().equalsIgnoreCase("Actor")) {
                actorsHTML.append("<tr><td>").append(resource.toHTML()).append("</td></tr>");
                actorCount++;
            }
            if (resource.getType().equalsIgnoreCase("Channel")) {
                channelsHTML.append("<tr><td>").append(resource.toHTML()).append("</td></tr>");
                channelCount++;
            }
            if (resource.getType().equalsIgnoreCase("Role")) {
                rolesHTML.append("<tr><td>").append(resource.toHTML()).append("</td></tr>");
                roleCount++;
            }
            

            try {
                resource = this.browser.nextResource();
                resourceCount++;
            }
            catch(Exception e) {
               e.printStackTrace();
            }
            
            if(resourceCount % PAGE_SIZE == 0) {
                
                pageCount++;
                
                documentsHTML.append("</table></body></html>");
                actorsHTML.append("</table></body></html>");
                channelsHTML.append("</table></body></html>");
                rolesHTML.append("</table></body></html>");
                this.documentsPanel.setBorder(new TitledBorder("Documents " + "("+ documentCount + ")"));
                this.actorsPanel.setBorder(new TitledBorder("Actors " + "("+ actorCount + ")"));
                this.channelsPanel.setBorder(new TitledBorder("Channels " + "("+ channelCount + ")"));
                this.rolesPanel.setBorder(new TitledBorder("Roles " + "("+ roleCount + ")"));
                
                this.documentsPages.add(documentsHTML.toString());
                this.actorsPages.add(actorsHTML.toString());
                this.channelsPages.add(channelsHTML.toString());
                this.rolesPages.add(rolesHTML.toString());
                
                documentsHTML = new StringBuffer("<html><body><table border=\"1\" width=\"100%\">");
                actorsHTML = new StringBuffer("<html><body><table border=\"1\" width=\"100%\">");
                channelsHTML = new StringBuffer("<html><body><table border=\"1\" width=\"100%\">");
                rolesHTML = new StringBuffer("<html><body><table border=\"1\" width=\"100%\">");

            }
        }
        
        this.documentsPages.add(documentsHTML.toString());
        this.actorsPages.add(actorsHTML.toString());
        this.channelsPages.add(channelsHTML.toString());
        this.rolesPages.add(rolesHTML.toString());
        
        documentsHTML = new StringBuffer("<html><body><table border=\"1\" width=\"100%\">");
        actorsHTML = new StringBuffer("<html><body><table border=\"1\" width=\"100%\">");
        channelsHTML = new StringBuffer("<html><body><table border=\"1\" width=\"100%\">");
        rolesHTML = new StringBuffer("<html><body><table border=\"1\" width=\"100%\">");
        
        
        this.resourcePanelBorder.setTitle(RESOURCE_PANEL_TITLE_FORMINGVIEW);
        this.resourcePanel.repaint();
        
        documentsHTMLPanel.setText((String)this.documentsPages.get(0));
        actorsHTMLPanel.setText((String)this.actorsPages.get(0));
        channelsHTMLPanel.setText((String)this.channelsPages.get(0));
        rolesHTMLPanel.setText((String)this.rolesPages.get(0));
        
        
        this.resourcePanelBorder.setTitle(RESOURCE_PANEL_TITLE_NORMAL + " page " + 
                (this.currentPage + 1) + " of " + this.pageCount + " (" + this.PAGE_SIZE + " per page)");
        this.resourcePanel.repaint();
        
        this.updatingView = false;
    }
    
    private void nextPage(MouseEvent event) {
        
        if(this.updatingView) {
            return;
        }
        
        int maxPage = this.pageCount - 1;
        
        if(this.currentPage == maxPage) {
            return;
        }
        
        this.currentPage++;
        
        documentsHTMLPanel.setText((String)this.documentsPages.get(this.currentPage));
        actorsHTMLPanel.setText((String)this.actorsPages.get(this.currentPage));
        channelsHTMLPanel.setText((String)this.channelsPages.get(this.currentPage));
        rolesHTMLPanel.setText((String)this.rolesPages.get(this.currentPage));
        
        this.resourcePanelBorder.setTitle(RESOURCE_PANEL_TITLE_NORMAL + " page " + 
                (this.currentPage + 1) + " of " + this.pageCount);
        this.resourcePanel.repaint();
    }
    
    private void previousPage(MouseEvent event) {
        
        if(this.updatingView) {
            return;
        }
        
        if(this.currentPage == 0) {
            return;
        }
        
        this.currentPage--;
        
        documentsHTMLPanel.setText((String)this.documentsPages.get(this.currentPage));
        actorsHTMLPanel.setText((String)this.actorsPages.get(this.currentPage));
        channelsHTMLPanel.setText((String)this.channelsPages.get(this.currentPage));
        rolesHTMLPanel.setText((String)this.rolesPages.get(this.currentPage));
        
        this.resourcePanelBorder.setTitle(RESOURCE_PANEL_TITLE_NORMAL + " page " + 
                (this.currentPage + 1) + " of " + this.pageCount);
        this.resourcePanel.repaint();
    }
    
}
