/**
* DataSource.java
* 
* v0.1
*
* 18.11.2005
* 
* @author Antti Laitinen
* 
* This software is released under the GNU GPL license
*/
package maito.datacollecting;

/**
 * <p>Represents a data source where data is collected from.
 * 
 * <p>All implementing classes MUST have a constructor with 2 parameters. 
 * The first parameter must be a java.util.Properties containing implementation spesific parameters.
 * The second parameter must be a maito.datacollecting.RecordParser.
 * 
 * @see maito.datacollecting.RecordParser
 */
public interface DataSource {

	/**
	 *Implementing classes must perform the updating here.
	 */
	public abstract void update() throws DataSourceException;
}

