package maito.datacollecting;

/**
 * A class that holds all necessary information of a data source.
 * 
 * @see maito.datacollecting.DataCollector
 * @see maito.datacollecting.DataSource
 * 
 * @author Antti Laitinen
 *
 */
public class DataSourceDescription {

    public static final int IDLENGTH = 100;

    private String id;
    private String updated;
    private String modified;
    private long sizeInRows;
    private String dataFormat;
    private boolean integrated;
	
	public DataSourceDescription(String id, String updated, String modified, 
			long sizeInRows, String dataFormat, boolean integrated) {
	
        this.id = id;
		this.updated = updated;
		this.modified = modified;
		this.sizeInRows = sizeInRows;
		this.dataFormat = dataFormat;
        this.integrated = integrated;
	}
    
    public String getId() {
        return this.id;
    }
    
    /**
     * Returns the date when this data source was last updated.
     * @return
     * A date in the format <code>yyyy-MM-dd</code>
     */
    public String getUpdated() {
        return this.updated;
    }
    
    /**
     * Returns the date when this data source was last modified.
     * @return
     * A date in the format <code>yyyy-MM-dd</code>
     */
    public String getModified() {
        return this.modified;
    }
    
    public long getSizeInRows() {
        return this.sizeInRows;
    }
    
    public String getDataFormat() {
        return this.dataFormat;
    }
    
    public boolean isIntegrated() {
        return this.integrated;
    }
    
    /**
     * Two DataSourceDescription objects are seen as equal if they have the same id.
     * @param other
     * @return
     */
    public boolean equals(DataSourceDescription other) {
        return this.id == other.getId();
    }
    
    public String toString() {
        return this.id + " [updated: " + this.updated + 
        ", modified: " + this.modified + ", rows: " + this.sizeInRows +
        ", format: " + this.dataFormat + ", is integrated: " + this.integrated + "]";
        }
}
