package maito.datacollecting;

/**
 * <p>A common interface for different implementations for parsing complete records 
 * from a stream of text data. Either the transfer type or the data format determines
 * the implementation. 
 * 
 * <p>All implementing classes MUST have a constructor that has two parameters.
 * The first parameter must be a maito.datacollecting.RecordConstructor.
 * The second parameter must be a maito.datacollecting.DataStorage.
 * 
 * @see maito.datacollecting.RecordConstructor
 * @see maito.datacollecting.DataStorage
 * 
 * @author Antti Laitinen
 *
 *
 */
public interface RecordParser {
	
	public void putData(String part); 
}
