package maito.datacollecting;

import maito.datacollecting.Record;

/**
 * A common interface for different implementations for transforming a data format to the
 * common format used by this program. Each data format has it's own implementation of this interface.
 * @author Antti Laitinen
 *
 * @see maito.datacollecting.Record
 *
 */
public interface Transformer {

	/**
	 * @param record 
	 * A record object that represents a record in a format that the implementing Tranformer is able to transform.
	 * @return
	 * Returns a Record object that is transformed to the unified record format that this program uses. 
	 */
	public Record transform(Record record) throws TransformException;
}
