package maito.datacollecting.dcxml;

import maito.datacollecting.RecordConstructor;
import maito.datacollecting.Record;

/**
* Constructs a Record object from a valid XML String that specifies
* a record in Dublin Core 2.0 XML format (simple elements plus qualified
* extensions specified in the specifications document).
*  
* @version 0.1
* @author Väinö Ala-Härkönen
*/
public class DCXMLRecordConstructor implements RecordConstructor{
    
    private DCXMLRecordConstructWorker constructor = new DCXMLRecordConstructWorker();
    
    /**
     * Constructs a record from the data string. The string must be a string
     * representation of a valid XML document. Root tag should be "record"
     * @param data
     * The data the Record should be constructed from
     * @return
     * A Record ready for transformation
     * @throws IllegalArgumentException
     */
    public Record constructRecord(String data) throws IllegalArgumentException {
        Record rec;
        rec = constructor.constructRecord(data, DCXMLRecordConstructWorker.RECORD_DCXML);
        return rec;
    }
    
}