package maito.datacollecting.dcxml;

import maito.datacollecting.Record;
import maito.datacollecting.RecordConstructor;

/**
* Constructs a Record object from a valid XML String that specifies
* a record in oai_citeseer XML format (including DC 2.0 simple elements and qualified
* extensions plus oai_citeseer specific elements specified in the specifications document )
*  
* @version 1.0
* @author Väinö Ala-Härkönen
* 
* 16.11.2005
* 
* This software is released under the GNU GPL license
*/
public class OAICiteseerRecordConstructor implements RecordConstructor {

    private DCXMLRecordConstructWorker constructor = new DCXMLRecordConstructWorker();
    
    /**
     * Constructs a record from the data string. The string must be a string
     * representation of a valid XML document. Root tag should be "record"
     * @param data
     * The data the Record should be constructed from
     * @return
     * A Record ready for transformation
     * @throws IllegalArgumentException
     */
    public Record constructRecord(String data) throws IllegalArgumentException {
        Record rec;
        rec = constructor.constructRecord(data, DCXMLRecordConstructWorker.RECORD_CITESEER);
        return rec;
    }
    
}
