package maito.datacollecting.dcxml;

import maito.datacollecting.Record;
import maito.datacollecting.TransformException;
import maito.datacollecting.Transformer;
import maito.datacollecting.dcxml.DCXMLTransformWorker;
import maito.util.Tools;

/**
 * A class that implements the generic DC XML transformation
 * with oai_citeseer type name handling heuristics and extra tags
 * Null values in source data aren't inserted to the constructed record.
 * 
 * @version 1.0
 * @author Väinö Ala-Härkönen
 */
public class OAICiteseerTransformer implements Transformer {

    public Record transform(Record record) throws TransformException {
        if (record != null) {
            Record internalRecord = DCXMLTransformWorker.transform(record, Tools.ACTOR_CITESEER);
            return internalRecord;
        }
        else { //??
            throw new TransformException();
        }
    }

}
