package maito.datacollecting.oaipmh;

import org.xml.sax.*;

/**
 * A class for parsing the OAI-PMH resonse for the verb ListRecords using SAX.
 * A possible OAI-PMH error and a resumption token are stored from the document and are accessible
 * after parsing.
 * 
 * @author Antti Laitinen
 */
public class ListRecordsContentHandler implements ContentHandler, ErrorHandler {

    private boolean readingResumptionToken = false;
    
    private boolean readingError = false;
    
    private String resumptionToken = null;
    
    private String error = null;
    
    protected ListRecordsContentHandler() {
        
    }
    
    /**
     * Returns the resumption token found in the document.
     * @return
     * The resumption token as a String. null if no resumption token was found.
     */
    protected String getResumptionToken() {
        return this.resumptionToken;
    }
    
    /**
     * Returns the OAI-PMH error found in the document.
     * @return
     * The error as a String. null if no error was found.
     */
    protected String getError() {
        return this.error;
    }
    
    
    public void startDocument() {
        this.error = null;
        this.resumptionToken = null;
    }
    
    
    public void startElement(String uri, String localName, String qName, Attributes atts) {
        
        if(localName.equalsIgnoreCase("resumptionToken")) {
            this.readingResumptionToken = true;
        }
        if(localName.equalsIgnoreCase("error")) {
            this.readingError = true; 
        }
    }

    
    public void endElement(String uri, String localName, String qName) {
        
        if(localName.equalsIgnoreCase("resumptionToken")) {
            this.readingResumptionToken = false;
        }
        if(localName.equalsIgnoreCase("error")) {
            this.readingError = false; 
        }
    }
    
    
    public void characters(char[] ch, int start, int length) {
        
        if(this.readingResumptionToken) {
            StringBuffer temp = new StringBuffer();
            
            for(int i = 0 ; i < length ; i++) {
                temp.append(ch[start + i]);
            }
            
            this.resumptionToken = temp.toString();
        }
        
        if(this.readingError) {
            StringBuffer temp = new StringBuffer();
            
            for(int i = 0 ; i < length ; i++) {
                temp.append(ch[start + i]);
            }
            
            this.error = temp.toString();
        }
    }
    
    /*These methods are required by the ContentHandler interface but are not needed*/
    public void endDocument() {}
    public void endPrefixMapping(String prefix) {}
    public void ignorableWhitespace(char[] ch, int start, int length) {}
    public void processingInstruction(String target, String data) {}
    public void setDocumentLocator(Locator locator) {}
    public void skippedEntity(String name) {}
    public void startPrefixMapping(String prefix, String uri) {}
    
    /*These methods are required by the ErrorHandler interface but are not needed*/
    
    public void error(SAXParseException exception) {}
    public void fatalError(SAXParseException exception) {}
    public void warning(SAXParseException exception) {}
}
