package maito.datacollecting.quickformat;

import maito.datacollecting.Record;
import maito.datacollecting.RecordConstructor;

/**
* Constructs a Record object from a valid String that specifies
* a record in quickformat document format
*  
* @version 1.0
* @author Väinö Ala-Härkönen
*/
public class QuickformatDocumentRecordConstructor implements RecordConstructor {

    StringBuffer dataBuffer;
    int lineBreakPos;
    
    /*
     * These are the type identifiers we're accepting
     * These are used for prefix matching so when adding new ones,
     * make sure they're ordered accordingly (ie. 3.1 before 3)
     */    
    private static final String[] VALIDTYPES = 
    { "1", "2", "3", "4", "5", "6", "7", "8", "9",};
    
    /*
     * The type name tags for the identifiers
     */
    private static final String[] TYPENAMES =    
    { "documentqf:creator", "documentqf:title", 
      "documentqf:publisher",  "documentqf:publication", "documentqf:publishedYear", 
      "documentqf:referenceIdentifier", "documentqf:isReferencedBy", "documentqf:references", 
      "documentqf:keywords" };
    
    public Record constructRecord(String data) throws IllegalArgumentException {
        
        dataBuffer = new StringBuffer(data);
        String line;
                
        // Create the record, first line = id
        //System.out.println("original: " + data);
        Record rec = null;
        line = getLineFromBuffer();
 
        /* NOTE:
         * The first line should be ignored if it contains the separator lines
         * The separator lines should be always included in the record String so that 
         * the DataStorage doesn't mess up writing the local file copy
         */
        if (line.equals("---")) { 
            line = getLineFromBuffer();
        }
        if (line != null) {
            //System.out.println("id: " + line);
            rec = new Record(line);
            rec.setField("documentqf:identifier", line);
        }
        
        // add the non-empty fields
        while ((line = getLineFromBuffer()) != null) {
            if (line.trim().length() > 1) { // process only if the field has a value
                for (int i = 0; i < VALIDTYPES.length; i++) {
                    if (line.startsWith(VALIDTYPES[i])) {
                        line = line.substring(VALIDTYPES[i].length());
                        //System.out.println(TYPENAMES[i] + ": " + line);
                        rec.setField(TYPENAMES[i], line);
                        break;
                    }
                }
            }
        }
        return rec;
    }

    // Removes and returns a line from the buffer, null if empty
    private String getLineFromBuffer() {
        String thisLine;
        lineBreakPos = dataBuffer.indexOf("\n");
        if (lineBreakPos != -1) {
            thisLine = dataBuffer.substring(0, lineBreakPos);
            dataBuffer.delete(0, lineBreakPos + 1);
            return thisLine;
        }
        return null;
    }
}
