package maito.datacollecting.quickformat;

import maito.datacollecting.Record;
import maito.datacollecting.RecordConstructor;

/**
* Constructs a Record object from a valid String that specifies
* a record in quickformat name format
*  
* @version 1.0
* @author Väinö Ala-Härkönen
*/
public class QuickformatNameRecordConstructor implements RecordConstructor {
    
    /*
     * These are the type identifiers we're accepting
     * These are used for prefix matching so when adding new ones,
     * make sure they're ordered accordingly (ie. 3.1 before 3)
     */    
    private static final String[] VALIDTYPES = 
    { "2.1", "2.2", "2", "3.1", "3", "4.1", "4.2", "4.3", "4.4", "4.5", "4"};
    
    /*
     * The type name tags for the identifiers
     */
    private static final String[] TYPENAMES =    
    { "nameqf:person", "nameqf:organization", "nameqf:actorUnknown",  
      "nameqf:publisher", "nameqf:roleUnknown",  
      "nameqf:magazine", "nameqf:conference", "nameqf:publicationSet", 
      "nameqf:reportSet", "nameqf:database", "nameqf:channelUnknown"};

    public Record constructRecord(String data) throws IllegalArgumentException {
        
        Record record = null;
            // a valid parsed name quickformat record should have a valid type identifier and some data
        if (data.length() > 1 && data != null) {            
            for (int i = 0; i < VALIDTYPES.length; i++) {
                if (data.startsWith(VALIDTYPES[i])) {
                    data = data.substring(VALIDTYPES[i].length());
                    
                    // get the id part of the string
                    String[] dataID = data.split("¤");                    
                    dataID = dataID[0].split(": ");
                    dataID = dataID[0].split("\\|");
                    
                    record = new Record(dataID[0]);
                    //System.out.println("id: " + dataID[0] + ", " + TYPENAMES[i] + ": " + data);
                    record.setField(TYPENAMES[i], data);
                }
            }
        }
        return record;
    }

}
