package maito.datacollecting.quickformat;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

import maito.datacollecting.Record;
import maito.datacollecting.TransformException;
import maito.datacollecting.Transformer;
import maito.util.Tools;

/**
 * QuickformatTransformer
 * 
 * Transforms quickformat-type data.
 * 
 * 
 * @version 3.0
 * @author Reima Halmetoja
 */
public class QuickformatTransformer implements Transformer {
    /**
     * @param record 
     * A record object that represents a record in either document-quickformat
     * or name-quickformat
     *
     * Keys of the fields must be in format documentqf:fieldName (or nameqf:fieldName)
     * @return
     * Returns a Record object containing data that is transformed to the 
     * unified record format that this program uses. 
     */    
    public Record transform(Record record) throws TransformException {
    	if (record != null) {
	        Record internalRecord = new Record(record.getID());    
	        HashSet recordFields = record.getFieldNames();
	        Iterator recordIterator = recordFields.iterator();
	        Iterator fieldIte;
	        String thisKey, thisValue;
	        String[] actorValues;
	        String[] thisValues;
	        Vector thisVector;
	        int dataType = Tools.ACTOR_OTHER;

	        while (recordIterator.hasNext()) {
	            thisKey = (String)recordIterator.next();
       	            
	            if (thisKey.equals("documentqf:identifier")) {
	                thisVector = record.getField("documentqf:identifier");
	                for (fieldIte = thisVector.iterator(); fieldIte.hasNext();) {
	                    thisValue = (String) fieldIte.next();
	                    if (thisValue != null) {
		                   	thisValues = thisValue.split("¤");
		                    for (int i = 0; i < thisValues.length; i++) {
		    	 				internalRecord.setField("SisäinenTunniste", thisValues[i]);
		    				}
	                    }
	                }
	            }
	            else if (thisKey.equals("documentqf:creator")) {
	                thisVector = record.getField("documentqf:creator");
	                for (fieldIte = thisVector.iterator(); fieldIte.hasNext();) {
	                    thisValue = (String) fieldIte.next();
	                    if (thisValue != null) {
	                    	thisValues = thisValue.split("¤");
	                        for (int i = 0; i < thisValues.length; i++) {
	    	 					// HenkilöTekijä/OrganisaatioTekijä/JokuTekijä
                                actorValues = Tools.canonizeActor(thisValues[i], dataType);
                                internalRecord.setField(actorValues[0] + "Tekijä", thisValues[i]);
	    					}
	                    }
	                }
	            }
	            else if (thisKey.equals("documentqf:title")) {
	                thisVector = record.getField("documentqf:title");
	                for (fieldIte = thisVector.iterator(); fieldIte.hasNext();) {
	                    thisValue = (String) fieldIte.next();
	                    if (thisValue != null) {
	                    	thisValues = thisValue.split("¤");
		                    for (int i = 0; i < thisValues.length; i++) {
		                        internalRecord.setField("Nimeke", thisValues[i]);                  
		                    }
	                    }
	                }
	            }
	            else if (thisKey.equals("documentqf:publisher")) {
	            	thisVector = record.getField("documentqf:publisher"); //rightsholder
	                for (fieldIte = thisVector.iterator(); fieldIte.hasNext();) {
	                    thisValue = (String) fieldIte.next();
	                    if (thisValue != null) {
		                    thisValues = thisValue.split("¤");
		                    for (int i = 0; i < thisValues.length; i++) {
		                        // HenkilöJulkaisija/OrganisaatioJulkaisija/JokuJulkaisija
                                actorValues = Tools.canonizeActor(thisValues[i], dataType);
                                internalRecord.setField(actorValues[0] + "Julkaisija", thisValues[i]);
		                    }
	                    }
	                }
	            }
	            else if (thisKey.equals("documentqf:publication")) {
	            	thisVector = record.getField("documentqf:publication");
	                for (fieldIte = thisVector.iterator(); fieldIte.hasNext();) {
	                    thisValue = (String) fieldIte.next();
	                    thisValues = thisValue.split("¤");
	                    if (thisValue != null) {
		                    for (int i = 0; i < thisValues.length; i++) {
		                        internalRecord.setField("JulkaisuNimi", thisValues[i]);               
		                    }
	                    }
	                }            	
	            }
	            else if (thisKey.equals("documentqf:publishedYear")) {
	            	thisVector = record.getField("documentqf:publishedYear");         
					String canonizedDate;
		            for (fieldIte = thisVector.iterator(); fieldIte.hasNext();) {
						thisValue = (String) fieldIte.next();
						thisValues = thisValue.split("¤");
						if (thisValue != null) {
							for (int i = 0; i < thisValues.length; i++) {
								canonizedDate = Tools.canonizeDate(thisValues[i]);
		       	        		if (canonizedDate != null) { // Save only if in proper format
		                	    	internalRecord.setField("Julkaisupäivämäärä", canonizedDate);
								}
							}
	                  	}
	         		}
	            }
	            else if (thisKey.equals("documentqf:referenceIdentifier")) {
	                thisVector = record.getField("documentqf:referenceIdentifier");
	                for (fieldIte = thisVector.iterator(); fieldIte.hasNext();) {
	                    thisValue = (String) fieldIte.next();
	                    if (thisValue != null) {
		                    thisValues = thisValue.split("¤");
		                    for (int i = 0; i < thisValues.length; i++) {
		                    	internalRecord.setField("Viittaustunniste", thisValues[i]);                        
		                    }
	                    }
	                }            	
	            }
	            else if (thisKey.equals("documentqf:isReferencedBy")) {
	                thisVector = record.getField("documentqf:isReferencedBy");
	                for (fieldIte = thisVector.iterator(); fieldIte.hasNext();) {
	                    thisValue = (String) fieldIte.next();
	                    thisValues = thisValue.split("¤");
	                    for (int i = 0; i < thisValues.length; i++) {
	                        internalRecord.setField("Viitattu", thisValues[i]);                        
	                    }
	                }            	
	            }
	            else if (thisKey.equals("documentqf:references")) {
	            	thisVector = record.getField("documentqf:references");
	                for (fieldIte = thisVector.iterator(); fieldIte.hasNext();) {
	                    thisValue = (String) fieldIte.next();
	                    if (thisValue != null) {
	                    	thisValues = thisValue.split("¤");
		                    for (int i = 0; i < thisValues.length; i++) {
		                        internalRecord.setField("Viittaava", thisValues[i]);                        
		                    }
	                	}
		            }
	            }
	            else if (thisKey.equals("documentqf:keywords")) {
	                thisVector = record.getField("documentqf:keywords");
	                for (fieldIte = thisVector.iterator(); fieldIte.hasNext();) {
	                    thisValue = (String) fieldIte.next();
	                    if (thisValue != null) {
		                    thisValues = thisValue.split("¤");
		                    for (int i = 0; i < thisValues.length; i++) {
		                        internalRecord.setField("Hakusanat", Tools.canonizeGeneric(thisValues[i]));                        
		                    }
	                    }
	                }            	
	            }
	            
	            // The following are for name-type quickformat
	            
				else if (thisKey.equals("nameqf:actorUnknown")) {
					thisVector = record.getField("nameqf:actorUnknown");
	                for (fieldIte = thisVector.iterator(); fieldIte.hasNext();) {
	                    thisValue = (String) fieldIte.next();
	                    if (thisValue != null) {
	                    	Vector parsed = parseNameqf(thisValue);
	                    	thisValues = (String[])parsed.elementAt(0);
	        				internalRecord.setField("TuntematonToimija", thisValues[0]);
	        				setOtherFields(parsed, internalRecord);
	                    }
	            	}
				}
				else if (thisKey.equals("nameqf:person")) {
					thisVector = record.getField("nameqf:person");
	                for (fieldIte = thisVector.iterator(); fieldIte.hasNext();) {
	                    thisValue = (String) fieldIte.next();
	                    if (thisValue != null) {
	                    	Vector parsed = parseNameqf(thisValue);
	                    	thisValues = (String[])parsed.elementAt(0);
	                    	internalRecord.setField("HenkilöToimija", thisValues[0]);
	        				setOtherFields(parsed, internalRecord);
	                    }
	                }
				}
	            else if (thisKey.equals("nameqf:organization")) {
	                thisVector = record.getField("nameqf:organization");
	                for (fieldIte = thisVector.iterator(); fieldIte.hasNext();) {
	                    thisValue = (String) fieldIte.next();
	                    if (thisValue != null) {
	                    	Vector parsed = parseNameqf(thisValue);
	                    	thisValues = (String[])parsed.elementAt(0);
	        				internalRecord.setField("OrganisaatioToimija", thisValues[0]);
	        				setOtherFields(parsed, internalRecord);
	                    }
	                }
				}
	            else if (thisKey.equals("nameqf:roleUnknown")) {
	                thisVector = record.getField("nameqf:roleUnknown");
	                for (fieldIte = thisVector.iterator(); fieldIte.hasNext();) {
	                    thisValue = (String) fieldIte.next();
	                    if (thisValue != null) {
	                    	Vector parsed = parseNameqf(thisValue);
	                    	thisValues = (String[])parsed.elementAt(0);
	        				internalRecord.setField("JokuRooli", thisValues[0]);
	        				setOtherFields(parsed, internalRecord);
	                    }
	                }
	            }
	            else if (thisKey.equals("nameqf:publisher")) {
	            	thisVector = record.getField("nameqf:publisher");
	                for (fieldIte = thisVector.iterator(); fieldIte.hasNext();) {
	                    thisValue = (String) fieldIte.next();
	                    if (thisValue != null) {
	                    	Vector parsed = parseNameqf(thisValue);
	                    	thisValues = (String[])parsed.elementAt(0);
	        				internalRecord.setField("JokuJulkaisija", thisValues[0]);
	        				setOtherFields(parsed, internalRecord);
	                    }
	                }
				}
	            else if (thisKey.equals("nameqf:channelUnknown")) {
	            	thisVector = record.getField("nameqf:channelUnknown");
	                for (fieldIte = thisVector.iterator(); fieldIte.hasNext();) {
	                    thisValue = (String) fieldIte.next();
	                    if (thisValue != null) {
	                    	Vector parsed = parseNameqf(thisValue);
	                    	thisValues = (String[])parsed.elementAt(0);
	        				internalRecord.setField("JokuKanava", thisValues[0]);
	        				setOtherFields(parsed, internalRecord);
	                    }
	                }
				}
	            else if (thisKey.equals("nameqf:magazine")) {
	            	thisVector = record.getField("nameqf:magazine");
	                for (fieldIte = thisVector.iterator(); fieldIte.hasNext();) {
	                    thisValue = (String) fieldIte.next();
	                    if (thisValue != null) {
	                    	Vector parsed = parseNameqf(thisValue);
	                    	thisValues = (String[])parsed.elementAt(0);
	        				internalRecord.setField("LehtiKanava", thisValues[0]);
	        				setOtherFields(parsed, internalRecord);
	                    }
	                }
				}
	            else if (thisKey.equals("nameqf:conference")) {
	            	thisVector = record.getField("nameqf:conference");
	                for (fieldIte = thisVector.iterator(); fieldIte.hasNext();) {
	                    thisValue = (String) fieldIte.next();
	                    if (thisValue != null) {
	                    	Vector parsed = parseNameqf(thisValue);
	                    	thisValues = (String[])parsed.elementAt(0);
	        				internalRecord.setField("KonferenssiKanava", thisValues[0]);
	        				setOtherFields(parsed, internalRecord);
	                    }
	                }
				}
	            else if (thisKey.equals("nameqf:publicationSet")) {
	            	thisVector = record.getField("nameqf:publicationSet");
	                for (fieldIte = thisVector.iterator(); fieldIte.hasNext();) {
	                    thisValue = (String) fieldIte.next();
	                    if (thisValue != null) {
	                    	Vector parsed = parseNameqf(thisValue);
	                    	thisValues = (String[])parsed.elementAt(0);
	        				internalRecord.setField("JulkaisusarjaKanava", thisValues[0]);
	        				setOtherFields(parsed, internalRecord);
	                    }
	                }
				}
	            else if (thisKey.equals("nameqf:reportSet")) {
	            	thisVector = record.getField("nameqf:reportSet");
	                for (fieldIte = thisVector.iterator(); fieldIte.hasNext();) {
	                    thisValue = (String) fieldIte.next();
	                    if (thisValue != null) {
	                    	Vector parsed = parseNameqf(thisValue);
	                        thisValues = (String[])parsed.elementAt(0);
	        				internalRecord.setField("RaporttisarjaKanava", thisValues[0]);
	        				setOtherFields(parsed, internalRecord);
	                    }
	                }
				}
	            else if (thisKey.equals("nameqf:database")) {
	            	thisVector = record.getField("nameqf:database");
	                for (fieldIte = thisVector.iterator(); fieldIte.hasNext();) {
	                    thisValue = (String) fieldIte.next();
	                    if (thisValue != null) {
	                    	Vector parsed = parseNameqf(thisValue);
	                    	thisValues = (String[])parsed.elementAt(0);
	                    	internalRecord.setField("TietokantaKanava", thisValues[0]);
	        				setOtherFields(parsed, internalRecord);
	                    }
	                }
				}
	        }
	    	return internalRecord;
    	}
    	else
    		throw new TransformException(); // ??
    }
    
	private static Vector parseNameqf(String thisValue) {	
		Vector parsed = new Vector();
			
		// The data is in the format "aa¤bb¤cc: dd|e,f,g"
		String[] currency;
		String[] colon;
		String[] pipe;
		String[] comma;
		
		//Split by the '|' sign.
		pipe = thisValue.split("\\|");	
			
		if (pipe.length > 1) {
			//Split ','-separated values
			comma = pipe[1].split(",");
			parsed.add(0, comma);
		}
		else {
			parsed.add(0, null);
		}
		
		//Split by ": ".
		colon = pipe[0].split(": ");
			
		if (colon.length > 1) {
			parsed.add(0, colon[1]);
		}
		else { 
			parsed.add(0, null);
		}
		// Split by '¤', process the values.
		currency = colon[0].split("¤");
		parsed.add(0, currency);
			
		return parsed;
    }
	
	/*
	 * Simple private method for name-type quickformat to tidy up code. 
	 * This is a part of the code which doesn't change depending on the
	 * key value. 
	 */
	private static void setOtherFields(Vector parsed, Record internalRecord) {
		String[] thisValues = (String[])parsed.elementAt(0);
		
		for (int i=1; i < thisValues.length; i++) { // Elements separated by "¤"
			internalRecord.setField("SisäinenTunniste", Tools.canonizeGeneric(thisValues[i]));
		}
		if (parsed.elementAt(1) != null) { // Elements separated by "¤"
			internalRecord.setField("OrganisaatioHallinnoija", (String)parsed.elementAt(1));
		}
		if (parsed.elementAt(2) != null) { // Elements separated by "|" (and ",")
			thisValues = (String[])parsed.elementAt(2);
			for (int i=0; i<thisValues.length; i++) {
				internalRecord.setField("Aihe", Tools.canonizeGeneric(thisValues[i]));
			}
		}
	}
}