package maito.integration;

/**
 * Represents a data source that has been integrated into a resource graph.
 * 
 * @author Antti Laitinen
 *
 */
public class IntegratedSource {
    
    private String sourceId;
    private String integrationDate;
    
    protected IntegratedSource(String sourceId, String integrationDate) {
        this.sourceId = sourceId;
        this.integrationDate = integrationDate;
    }

    /**
     * Returns the id of the data source that this IntegratedSource represents.
     */
    public String getSource() {
        return this.sourceId;
    }
    
    /**
     * Returns the date when this source was integrated.
     * @return
     * A date as a String in the format <code>yyyy-MM-dd</code>.
     */
    public String getIntegrationDate() {
        return this.integrationDate;
    }
    
}
