package maito.browsing;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

import maito.resource.*;
import maito.util.DbTools;
import maito.util.Tools;
import junit.framework.TestCase;

/**
 * This test must be run so that the working directory is 'build'.
 * 
 */
public class DatabaseManagerTest extends TestCase {

    
private Connection con;
    
    public DatabaseManagerTest() {
        try {
            this.con = DbTools.createDbConnection(Tools.loadProperties("config/dbconfig.properties"));
            Statement stmt = this.con.createStatement();
            stmt.execute("CREATE DATABASE maito_resnet_TEST CHARACTER SET utf8;");
            stmt.execute("USE maito_resnet_TEST");
            
            String sqlScript = Tools.readFile("config/resourcegraph.sql");
            
//          execute each sql command from script
            int previous = 0;
            for (int i = sqlScript.indexOf(";", previous); i != -1; i = sqlScript
                    .indexOf(";", previous)) {

                String query = sqlScript.substring(previous, i);
                stmt.execute(query);
                previous = i + 1;
            }
        }
        catch(SQLException e) {
            e.printStackTrace();
            assertTrue(false);
        }
    }
    
    public void tearDown() {
        try {
            Statement stmt = this.con.createStatement();
            stmt.execute("DROP DATABASE maito_resnet_TEST");
        }
        catch(Exception e) {
            e.printStackTrace();
        }
    }
    
    public void testAll() {
        try  {
            Statement stmt = this.con.createStatement();
            
            /*remove any special resources that the script has put in the table*/
            stmt.execute("delete from Resource");
            
            /*create two resources and a role between their relation*/
            stmt.executeUpdate("insert into Resource values ('id','name','canonical','2005-01-01','Actor')");
            stmt.executeUpdate("insert into Actor values ('id','Joku')");
            
            stmt.executeUpdate("insert into Resource values ('id2','name2','canonical2','2005-01-01','Actor')");
            stmt.executeUpdate("insert into Actor values ('id2','Joku')");
            
            stmt.executeUpdate("insert into Resource values ('testrole','role','canonical','2005-01-01','Role')");
            stmt.executeUpdate("insert into Role values ('testrole','Joku')");
            
            /*add a relation*/
            stmt.executeUpdate("insert into ResourceRelation values ('testrole','id','id2')");
            
            DatabaseManager manager = new DatabaseManager();
            
            /*See that the database name can be found using getGraph()*/
            String[] graphs = manager.getGraphs();
            
            boolean databaseFound = false;
            for(int i = 0 ; i < graphs.length ; i++) {
                if(graphs[0].equals("maito_resnet_TEST")) {
                    databaseFound = true;
                    break;
                }
            }
            
            assertTrue(databaseFound);

            
            /*execute a query and start reading resources*/
            manager.executeSQL("select * from Resource", "maito_resnet_TEST");
            
            Resource resource = manager.nextResource();
            
            assertTrue(resource != null);
            
            while(!resource.getID().equals("id")) {
                resource = manager.nextResource();
            }
            assertTrue(resource.getType().equals("Actor"));
            
            /*read all the resources*/
            while(manager.nextResource() != null) { }
            
            
            /*See that the same query can be redone*/
            manager.executeLatestQuery();
            
            /*count the resources fetched from DatabaseManager*/
            int resourceCount = 0;
            
            resource = manager.nextResource();
            resourceCount++;
            
            assertTrue(resource != null);
            
            while(!resource.getID().equals("id")) {
                resource = manager.nextResource();
                resourceCount++;
            }
            assertTrue(resource.getType().equals("Actor"));
            
            ResourceRelation[] relations = manager.getRelations(resource);
            
            assertTrue(relations.length == 1);
            assertTrue(relations[0].getRole().equals("testrole"));
            assertTrue(relations[0].getSubject().equals("id"));
            assertTrue(relations[0].getObject().equals("id2"));
            
            /*extract rest of the resources*/
            while(manager.nextResource() != null) {
                resourceCount++;
            }
            
            /*there should've been the two Actor resources plus the Role resource*/
            assertTrue(resourceCount == 3);
        }
        catch(Exception e) {
            e.printStackTrace();
            assertTrue(false);
        }
    }
}
