/**
 * CSVResourceListFormatTest
 * 
 * NOTE: The working directory for this test must be
 * set to the program root, otherwise it will not work
 * correctly. Also, the test renames a config file momentarily
 * which isn't neat behaviour at all.
 * 
 * @author Väinö Ala-Härkönen
 */
package maito.browsing.fileexport;

import java.io.File;

import maito.resource.Resource;
import maito.resource.ResourceRelation;

import junit.framework.TestCase;

public class CSVResourceListFormatTest extends TestCase {
    
    CSVResourceListFormat csvformat;
    
        
    public void testWriteFile() {
        csvformat = new CSVResourceListFormat();

        Resource[] testResources = new Resource[4];
        ResourceRelation[] testRelations = new ResourceRelation[4];        
        
        testResources[0] = new Resource("TESTI 1", "Actor");
        testResources[0].setField("Resource.name", "Test name");
        testResources[0].setField("Actor.type", "Test actor");
        testResources[0].setField("KeyWords.keyword", "The first \"test keyword\"");
        testResources[0].setField("KeyWords.keyword", "The second test key word, which is quite long indeed");
        testResources[0].setField("ExtIDs.extID", "123456");
        testResources[0].setField("ExtIDs.extID", "ABCDEFGHIJ");

        testResources[1] = new Resource("TESTI 2", "Actor");
        
        testResources[2] = new Resource("TESTI 3", "Document");
        testResources[2].setField("Resource.name", "Test document");
        testResources[2].setField("Document.title", "The usage of dry \"British style\" humor in test cases, second version");
        testResources[2].setField("ExtIDs.extID", "1234569324813");
        testResources[2].setField("ExtIDs.extID", "ABCDEFGHIJSDFASF");
        
        testResources[3] = new Resource(null, null);
        
        testRelations[0] = new ResourceRelation("TESTI 1", "TESTI 2", "Test role 1");
        testRelations[1] = new ResourceRelation("TESTI \"3\"", null, "Test role 2");
        testRelations[2] = new ResourceRelation("TESTI 4", "TESTI 1", null);
        testRelations[3] = new ResourceRelation(null, "TESTI 1", "Test role 4");

        csvformat.setResources(testResources);
        csvformat.setRelations(testRelations);
        
        File tempFile = null;
        String tempPath = "";
        
        try {
            tempFile = File.createTempFile("CSVResourceListFormatTest.csv", null);
            tempPath = tempFile.getAbsolutePath();
            //tempFile.deleteOnExit();
        }
        catch (Exception e) {
            System.out.println("Test error: " + e);
            assertTrue(false);
        }
        
        assertTrue(csvformat.writeFile(tempPath));
        
        csvformat.setResources(null);
        assertTrue(csvformat.writeFile(tempPath));
        
        csvformat.setRelations(null);
        csvformat.setResources(testResources);
        assertTrue(csvformat.writeFile(tempPath));
        
        csvformat.setResources(null);
        assertTrue(csvformat.writeFile(tempPath) == false);
        assertTrue(csvformat.writeFile(".%.&.?!?!") == false);
    }

    // this one renames a file to cause an error in config loading
    public void testFaultyExport() {
        File oldname = new File("config" + File.separator + "csvlistexport.properties");
        File newname = new File("config" + File.separator + "csvlistexport.testproperties");
        
        oldname.renameTo(newname);
        // This should cause the fileformat not to find its configuration
        CSVResourceListFormat faultycsv = new CSVResourceListFormat();
        newname.renameTo(oldname);
        assertTrue(!faultycsv.writeFile("foo"));
    }

}
