/**
 * FileExporterImplTest
 * 
 * NOTE: The working directory for this test must be
 * set to the program root, otherwise it will not work
 * correctly. Also, the test renames a config file momentarily
 * which isn't neat behaviour at all.
 * 
 * NOTE: Test coverage at way 88% since some error conditions
 * are hard to test automatically and reasonably.
 *
 * 
 * @author Väinö Ala-Härkönen
 */
package maito.browsing.fileexport;

import java.io.BufferedReader;
import java.io.File;

import maito.resource.Resource;
import maito.resource.ResourceRelation;
import junit.framework.TestCase;

public class FileExporterImplTest extends TestCase {

    FileExporterImpl exporter = new FileExporterImpl();
    String[] formats = exporter.getFormats();
        
    public void testFaultyExport() {
        File oldname = new File("config" + File.separator + "exportformats.properties");
        File newname = new File("config" + File.separator + "exportformats.testproperties");
        
        oldname.renameTo(newname);
        // This should cause the exporter not to find its configuration
        FileExporterImpl faultyExporter = new FileExporterImpl();
        newname.renameTo(oldname);
        
        assertTrue(faultyExporter.getFormats() == null);
    }
    
    public void testMiscExport() {        
        assertTrue(formats[0].equals("pajek_net"));
        assertTrue(formats[1].equals("csv_resourcelist"));
        
        assertTrue(exporter.writeFile("filename", "foobar", null, null) == false);
        assertTrue(exporter.writeFile("filename", "pajek_net", null, null) == false);
    }

    public void testSuccesfulExport() {
        
        File tempFile = null;
        String tempPath = "";
        
        Resource[] testResources = new Resource[4];
        ResourceRelation[] testRelations = new ResourceRelation[4];
        
        testResources[0] = new Resource("TESTI 1", "Actor");
        testResources[1] = new Resource("TESTI 2", "Actor");
        testResources[2] = new Resource("TESTI 3", "Document");
        testResources[3] = new Resource(null, null);
        
        testRelations[0] = new ResourceRelation("TESTI 1", "TESTI 2", "Testirooli");
        testRelations[1] = new ResourceRelation("TESTI 3", "TESTI 4", "Testirooli");  
        testRelations[2] = new ResourceRelation("TESTI 4", "TESTI 1", "Testirooli");  
        testRelations[3] = new ResourceRelation("TESTI 3", "TESTI 1", "Testirooli");  
        
        try {
            tempFile = File.createTempFile("PajekFormatTest.net", null);
            tempFile.deleteOnExit();
            tempPath = tempFile.getAbsolutePath();
        }
        catch (Exception e) {
            System.out.println(e);
            assertTrue(false);
        }
        
        assertTrue(exporter.writeFile(tempPath, "pajek_net", testResources, testRelations));
    }
    
}
