/**
 * PajekFormatTest
 * 
 * @author Väinö Ala-Härkönen
 * 
 * NOTE: This test writes data to a file and reads it. 
 * Thus the test will fail if there's no read + write access to
 * system temp directory for some reason.
 */
package maito.browsing.fileexport;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;

import maito.resource.Resource;
import maito.resource.ResourceRelation;
import junit.framework.TestCase;

public class PajekFormatTest extends TestCase {

    /*
     * Test method for 'maito.browsing.fileexport.PajekFormat.writeFile(String)'
     */
    public void testWriteFile() {
        File tempFile = null;
        String tempPath = "";
        
        Resource[] testResources = new Resource[4];
        ResourceRelation[] testRelations = new ResourceRelation[4];
        
        testResources[0] = new Resource("TESTI 1", "Actor");
        testResources[1] = new Resource("TESTI 2", "Actor");
        testResources[2] = new Resource("TESTI 3", "Document");
        testResources[3] = new Resource(null, null);
        
        testRelations[0] = new ResourceRelation("TESTI 1", "TESTI 2", "Testirooli");
        testRelations[1] = new ResourceRelation("TESTI 3", "TESTI 4", "Testirooli");  
        testRelations[2] = new ResourceRelation("TESTI 4", "TESTI 1", "Testirooli");  
        testRelations[3] = new ResourceRelation("TESTI 3", "TESTI 1", "Testirooli");  
        
        try {
            tempFile = File.createTempFile("PajekFormatTest.net", null);
            tempPath = tempFile.getAbsolutePath();
        }
        catch (Exception e) {
            System.out.println(e);
            assertTrue(false);
        }
        
        PajekFormat pajekWriter = new PajekFormat();
        pajekWriter.setResources(testResources);
        pajekWriter.setRelations(testRelations);
        assertTrue(pajekWriter.writeFile(tempPath));
        
        try {
            BufferedReader fread = new BufferedReader(new InputStreamReader(
                    new FileInputStream(tempFile), "UTF-8"));
            assertTrue(fread.readLine().equals("*Vertices 4"));
            assertTrue(fread.readLine().equals("1 \"TESTI 1\""));
            assertTrue(fread.readLine().equals("2 \"TESTI 2\""));
            assertTrue(fread.readLine().equals("3 \"TESTI 3\""));
            assertTrue(fread.readLine().equals("4 \"\""));
            assertTrue(fread.readLine().equals("*Arcs"));
            assertTrue(fread.readLine().equals("1 2"));
            assertTrue(fread.readLine().equals("3 1"));
            fread.close();
        }        
        catch (Exception e) {
            System.out.println(e);
            assertTrue(false);
        }

        
        pajekWriter.setResources(null);
        assertTrue(!pajekWriter.writeFile(tempPath));
        
        pajekWriter.setResources(testResources);
        pajekWriter.setRelations(null);
        assertTrue(!pajekWriter.writeFile(tempPath));
        
        assertTrue(!pajekWriter.writeFile(null));
    }

}
