package maito.datacollecting;

import junit.framework.TestCase;

/**
 * 
 * @author Antti Laitinen
 *
 */
public class DataSourceDescriptionTest extends TestCase {

    /**
     * Tests that the parameters given to the constructor are correctly
     * accessible using the corresponding methods.
     *
     */
    public void testDataIntegrity() {
        String id = "id";
        String updated = "updated";
        String modified = "modified";
        long size = 0;
        String format = "format";
        boolean integrated = true;
        
        DataSourceDescription desc = new DataSourceDescription(id,
                updated, modified, size, format, integrated);
        
        assertTrue(id.equals(desc.getId()));
        assertTrue(updated.equals(desc.getUpdated()));
        assertTrue(modified.equals(desc.getModified()));
        assertTrue(size == desc.getSizeInRows());
        assertTrue(format.equals(desc.getDataFormat()));
        assertTrue(integrated == desc.isIntegrated());
    }
    
    /**
     * Tests that the equals method works.
     *
     */
    public void testEquals() {
        String id = "id";
        String updated = "updated";
        String modified = "modified";
        long size = 0;
        String format = "format";
        boolean integrated = true;
        
        DataSourceDescription desc1 = new DataSourceDescription(id,
                updated, modified, size, format, integrated);
        
        DataSourceDescription desc2 = new DataSourceDescription(id,
                updated, modified, size, format, integrated);
        
        assertTrue(desc1.equals(desc2));
        
        DataSourceDescription desc3 = new DataSourceDescription("different id",
                updated, modified, size, format, integrated);
        
        assertTrue(!desc1.equals(desc3));
    }
    
    public void testToStringNotNull() {
        String id = "id";
        String updated = "updated";
        String modified = "modified";
        long size = 0;
        String format = "format";
        boolean integrated = true;
        
        DataSourceDescription desc = new DataSourceDescription(id,
                updated, modified, size, format, integrated);
        
        assertTrue(desc.toString() != null);
    }
}
