/*
 * DataStorageTest.java
 *
 * This software is released under the GNU GPL license
 *
 * Note: You'll have to check the test output manually to see if it
 * corresponds with the test input.
 */

package maito.datacollecting;

import java.io.File;

import java.sql.Connection;
import java.sql.Statement;
import java.sql.DriverManager;

import maito.datacollecting.dcxml.DCXMLTransformer;

import junit.framework.TestCase;

public class DataStorageTest extends TestCase {

    public DataStorageTest(String name) {
        super(name);
    }
    
	/*
	 * Tests for DataStorage.addRecord()
	 */
    public void testAddRecord() throws Exception {
		Class.forName("com.mysql.jdbc.Driver").newInstance();
		
		//Clean up the test file first
		File file = new File("build/data/testRecords.txt");
		assertTrue(file != null);
		try {
			file.delete();
		} catch(Exception e) {}
		
		Connection conn = DriverManager.getConnection(
		    "jdbc:mysql://localhost/maitotest?user=maito&password=maito");
		assertTrue(conn != null);
		
		//Clean up and setup the databases first
		Statement s = conn.createStatement();
		s.execute("TRUNCATE TABLE datasource");
		s.execute("TRUNCATE TABLE datarecord");
		s.execute("TRUNCATE TABLE statement");
		s.execute("INSERT INTO datasource SET id='storageID', format='dcxml', location='disk'");
		
		//Tests begin
		Record r = new Record("recordID-1");
		r.setField("dc:creator", "pekka");
		r.setField("dc:creator", "olli");
		r.setField("dc:type", "book");

		DataStorage ds = new DataStorage("storageID", conn, null, new DCXMLTransformer());
		assertTrue(!ds.addRecord(r, "<record>\n<id>r-1</id>\n</record>"));
		
		ds = new DataStorage("storageID", conn, new File("/&&/?%=#\\!"), new DCXMLTransformer());
		assertTrue(!ds.addRecord(r, "<record>\n<id>r-1</id>\n</record>"));

		ds = new DataStorage("bogusID", conn, file, new DCXMLTransformer());
		assertTrue(!ds.addRecord(r, "<record>\n<id>r-1</id>\n</record>"));
		
		ds = new DataStorage("storageID", conn, file, new DCXMLTransformer());
		assertTrue(ds.addRecord(r, "<record>\n<id>r-1</id>\n</record>"));

		r = new Record("recordID-1");
		r.setField("dc:creator", "pekka");
		r.setField("dc:creator", "olli");
		r.setField("dc:type", "book");
		assertTrue(ds.addRecord(r, "<record>\n<id>duplicate, this line should not appear!</id>\n</record>"));
		
		r = new Record("recordID-1");
		r.setField("dc:creator", "pekka2");
		r.setField("dc:creator", "olli");
		r.setField("dc:type", "book");
		assertTrue(ds.addRecord(r, "<record>\n<id>updated record1</id>\n</record>"));
		
		r = new Record("recordID-2");
		r.setField("", "emptyval");
		assertTrue(ds.addRecord(r, "<record>\n<id>r-2</id>\n</record>\n"));
		
		r = new Record("'sql' ''\"yeah\n%_");
		assertTrue(ds.addRecord(r, "\n\n"));
		
		conn.close();
    }
}
