/*
 * RecordTest.java
 *
 * This software is released under the GNU GPL.
 */

package maito.datacollecting;

import java.util.HashSet;
import java.util.Vector;

import junit.framework.TestCase;

public class RecordTest extends TestCase {

    public RecordTest(String name) {
        super(name);
    }
    
	/*
	 * Tests for Record.get*
	 */
    public void testRecordGetSets() {
        Record r = new Record("id");
        assertTrue(r.getID().equals("id"));
        
        assertTrue(!r.setField(null, "unset"));
        assertTrue(r.setField("author", "pekka"));
        assertTrue(r.setField("author", "olli"));
        assertTrue(r.setField("null", null));
        
        Vector v = r.getField("author");
        assertTrue(v != null);
        assertTrue(v.elementAt(0).equals("pekka"));
        assertTrue(v.elementAt(1).equals("olli"));
        
        v = r.getField("null");
        assertTrue(v != null);
        assertTrue(v.firstElement() == null);
        
        assertTrue(r.getField("unset") == null);
        assertTrue(r.getField(null) == null);
        
        HashSet hs = r.getFieldNames();
        assertTrue(hs.contains("author"));
        assertTrue(hs.contains("null"));
        assertTrue(!hs.contains("unset"));
    }
    
	/*
	 * Tests for Record.equals()
	 */
    public void testRecordEquals() {
        Record r1 = new Record("id");
        r1.setField("author", "pekka");
        r1.setField("keyword", "kw1");
        r1.setField("keyword", "kw1");
        r1.setField("keyword", "kw2");
        
        Record r2 = new Record("id");
        r2.setField("author", "pekka");
        r2.setField("keyword", "kw1");
        r2.setField("keyword", "kw2");
        r2.setField("keyword", "kw1");
        
        Record r5 = new Record("id");
        r5.setField("author", "pekka");
        r5.setField("keyword", "kw1");
        r5.setField("keyword", "kw2");

        Record r6 = new Record("id");
        r6.setField("author", "pekka");
        r6.setField("keyword", "kw1");
        r6.setField("title", "book");
        
        Record r7 = new Record("id");
        r7.setField("author", "pekka");
        r7.setField("type", "whatever");

        Record r8 = new Record("id");
        r8.setField("author", "pekka");
        r8.setField("keyword", "kw1");
        r8.setField("keyword", "kw2");
        r8.setField("keyword", "kw3");

        Record r9 = new Record("id");
        r9.setField("professor", null);
        
        Record r3 = new Record("differentid");
        Record r4 = new Record(null);
        assertTrue(r4.getID().equals(""));
        
        assertTrue(r1.equals(r1));
        assertTrue(r1.equals(r2));
        assertTrue(!r1.equals(r3));
        assertTrue(!r1.equals(r4));
        assertTrue(!r1.equals(null));
        assertTrue(!r1.equals(r5));
        assertTrue(!r1.equals(r6));
        assertTrue(!r1.equals(r7));
        assertTrue(!r1.equals(r8));
        assertTrue(r9.equals(r9));
    }
    
    /*
     * Tests for Record.integratedTo
     */
    public void testRecordIntegratedTo() {
        Record r = new Record("pexa");
        assertTrue(r.getIntegratedTo().equals(""));
        r.setIntegratedTo(null);
        assertTrue(r.getIntegratedTo().equals(""));
        r.setIntegratedTo("all your base");
        assertTrue(r.getIntegratedTo().equals("all your base"));
    }
    
    /*
     * Tests for Record.deleteField
     */
    public void testRecordDeleteField() {
        Record r = new Record("1836");
        r.setField("author", "pekka");
        r.setField("author", "pekka");
        r.setField("author", "kalle-axle");
        r.setField("location", "dachau");
        r.deleteField(null);
        r.deleteField("");
        r.deleteField("author");

        HashSet hs = r.getFieldNames();
        assertTrue(!hs.contains("author"));
        assertTrue(hs.contains("location"));
        Vector v = r.getField("location");
        assertTrue(v.elementAt(0).equals("dachau"));
    }
}
