/**
* DCXMLRecordConstructWorkerTest.java
* 
* v1.0
*
* 17.11.2005
* 
* This software is released under the GNU GPL license
* 
* @author Väinö Ala-Härkönen
* 
* Note: Block coverage at 96%, some mandatory XML error handling code is either 
* empty or useless - therefore it isn't covered in the tests.
*/
package maito.datacollecting.dcxml;

import junit.framework.TestCase;

public class DCXMLRecordConstructWorkerTest extends TestCase {

    DCXMLRecordConstructWorker worker = new DCXMLRecordConstructWorker();
    
    /*
     * Test method for 'maito.datacollecting.dcxml.DCXMLRecordConstructWorker.constructRecord(String, int)'
     */
    public void testConstructRecord() {
        
        String testrecord1 = "<record> <header> <identifier>oai:CiteSeerPSU:99107</identifier> " +
        "<datestamp>1996-06-07</datestamp> <setSpec>CiteSeerPSUset</setSpec> </header> " +
        "<metadata> <oai_citeseer:oai_citeseer xmlns:oai_citeseer=\"http://copper.ist.psu.edu/oai/oai_citeseer/\" xmlns:dc =\"http://purl.org/dc/elements/1.1/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://copper.ist.psu.edu/oai/oai_citeseer/ http://copper.ist.psu.edu/oai/oai_citeseer.xsd \"> " +
        "<dc:title>An Enumeration Algorithm for the Edge Coloring Problem on Bipartite Graphs</dc:title> " +
        "<oai_citeseer:author name=\"Yasuko Matsui\"> " +
        "<address>; Japan; Tokyo 113 , Japan; METR 95--09 (OCTOBER 1995)</address> " +
        "<affiliation>; Tomomi MATSUI; Tokyo Metropolitan University , Tokyo 192-03; University of Tokyo</affiliation> " +
        "</oai_citeseer:author> <dc:subject>Yasuko Matsui An Enumeration Algorithm for the Edge Coloring Problem on Bipartite Graphs</dc:subject> " +
        "<dc:description>. In this paper, we propose an algorithm for finding all the edge colorings in " +
        "bipartite graphs.</dc:description><dc:contributor>The Pennsylvania State University CiteSeer Archives</dc:contributor> " +
        "<dc:publisher>unknown</dc:publisher> <dc:date>1996-06-07</dc:date> <dc:format>ps</dc:format> " +
        "<dc:identifier>http://citeseer.ist.psu.edu/99107.html</dc:identifier> " +
        "<dc:source>http://misojiro.misojiro.t.u-tokyo.ac.jp/~tomomi/TRs/./METR95-09.ps.Z</dc:source> " +
        "<dc:language>en</dc:language> <oai_citeseer:relation type=\"References\"> " +
        "<oai_citeseer:uri>oai:CiteSeerPSU:48092</oai_citeseer:uri> </oai_citeseer:relation> " +
        "<oai_citeseer:relation type=\"References\"> <oai_citeseer:uri>oai:CiteSeerPSU:50984</oai_citeseer:uri> </oai_citeseer:relation> " +
        "<oai_citeseer:relation type=\"Is Referenced By\"> <oai_citeseer:uri>oai:CiteSeerPSU:8032</oai_citeseer:uri> " +
        "</oai_citeseer:relation> <oai_citeseer:relation type=\"Is Referenced By\"> <oai_citeseer:uri>oai:CiteSeerPSU:547119</oai_citeseer:uri> " +
        "</oai_citeseer:relation> <oai_citeseer:relation type=\"Is Referenced By\"> <oai_citeseer:uri>oai:CiteSeerPSU:566963</oai_citeseer:uri> " +
        "</oai_citeseer:relation> <oai_citeseer:relation type=\"Is Referenced By\"> <oai_citeseer:uri>oai:CiteSeerPSU:29249</oai_citeseer:uri> " +
        "</oai_citeseer:relation> <dc:rights>unrestricted</dc:rights> </oai_citeseer:oai_citeseer> " +
        "</metadata> </record>";
        
        try {
            worker.constructRecord(testrecord1, DCXMLRecordConstructWorker.RECORD_CITESEER);
        }
        catch (IllegalArgumentException e) {
            assertTrue(false);
        }
        
        String testrecord2 = "<record><header></record>";
        
        try {
            worker.constructRecord(testrecord2, DCXMLRecordConstructWorker.RECORD_CITESEER);
        }
        catch (IllegalArgumentException e) { // This doesn't happen anymore since faulty records are just ignored
            assertTrue(true);
        }
        
        try {
            worker.constructRecord(testrecord1, 2);
            assertTrue(false);
        }
        catch (IllegalArgumentException e) {
            assertTrue(true);
        }
        
        String recordWithoutID = "<record></record>";
        try {
            worker.constructRecord(recordWithoutID, DCXMLRecordConstructWorker.RECORD_DCXML);
        }
        catch (IllegalArgumentException e) {
            assertTrue(false);
        }
        
    }

    /*
     * Test method for 'maito.datacollecting.dcxml.DCXMLRecordConstructWorker.testNamespaceImpl()'
     */
    public void testTestNamespaceImpl() {
        assertTrue(worker.testNamespaceImpl());
    }

}
