/**
* DCXMLTransformerTest
* 
*
*
* 28.11.2005
* 
* This software is released under the GNU GPL license
*
* @version 2.0
* @author Väinö Ala-Härkönen
* @author Reima Halmetoja
* 
* Note: DCXMLTransformWorker coverage and some extra test cases
* are done in OAICiteseerTransformTest since
* the both tested classes basically act as wrappers for DCXMLTransformWorker
*/
package maito.datacollecting.dcxml;

import java.util.Vector;

import maito.datacollecting.Record;
import junit.framework.TestCase;

public class DCXMLTransformerTest extends TestCase {

    /*
     * Test method for 'maito.datacollecting.dcxml.DCXMLTransformer.transform(Record)'
     */
    public void testBasicTransform() {

        DCXMLTransformer testTfm = new DCXMLTransformer();

        Record nullRec = null;
        try {
            testTfm.transform(nullRec);
        }
        catch (Exception e) {
            assertTrue(true);
        }
        
        // Create a test record...
        Record testRec = new Record("testi");
        testRec.setField("dc:title", "Giambelli-type formula for subbundles of the tangent bundle");
        testRec.setField("dc:creator", "Shapiro, B.");
        testRec.setField("dc:creator", "Kazarian, M. E.");
        testRec.setField("dc:subject", "Algebraic Geometry");
        testRec.setField("dc:date","2004-08-12"); // also test vs issued
        testRec.setField("dc:subject", "5R20, 57R22");
        testRec.setField("dc:description", "  Let us consider a generic n-dimensional subbundle V.");
        testRec.setField("dc:description", "Comment: 18 pages, no figures, final version");
        testRec.setField("dc:publisher","MIT Press");
        testRec.setField("dc:contributor", " just me ");
        testRec.setField("dc:type", "text");
        testRec.setField("dc:format", "pdf");
        testRec.setField("dc:identifier","info:doi:10.1086/312511");
        testRec.setField("dc:identifier","http://arxiv.org/abs/astro-ph/0001087");
        testRec.setField("dc:language", "en-US");
        testRec.setField("dc:relation","test relation");
        testRec.setField("dc:bibliographicCitation","ABC1234");
        testRec.setField("dc:issued", "2004-08-13T12:33:44"); // overwrites date
        testRec.setField("dc:date", "2004-08-12"); // doesn't overwrite issued
        testRec.setField("dc:references","123456TEST");
        testRec.setField("dc:isReferencedBy","TEST123456");
        testRec.setField("dc:rightsHolder","Microsoft inc. ");
        
        // Then transform it...
        Record resultRec = new Record("foo");
        try {
            resultRec = testTfm.transform(testRec);
        }
        catch (Exception e) {
            assertTrue(false);
        }
        
        Vector temp;
        assertTrue(resultRec.getID().equals("testi"));
        
        temp = resultRec.getField("Nimeke");
        assertTrue(temp.size() == 1);
        assertTrue(temp.firstElement().equals("Giambelli-type formula for subbundles of the tangent bundle"));
        
        temp = resultRec.getField("KanoNimeke");
        assertTrue(temp.size() == 1);
        assertTrue(temp.firstElement().equals("GIAMBELLI-TYPE FORMULA SUBBUNDLES TANGENT BUNDLE"));
        
        temp = resultRec.getField("HenkilöTekijä");
        assertTrue(temp.size() == 2);
        assertTrue(temp.elementAt(0).equals("Shapiro, B."));
        assertTrue(temp.elementAt(1).equals("Kazarian, M. E."));
        
        temp = resultRec.getField("Aihe");
        assertTrue(temp.size() == 2);
        assertTrue(temp.elementAt(0).equals("ALGEBRAIC GEOMETRY"));
        assertTrue(temp.elementAt(1).equals("5R20, 57R22"));
        
        temp = resultRec.getField("Hakusanat");
        assertTrue(temp.size() == 3);
        assertTrue(temp.elementAt(0).equals("TEXT"));
        assertTrue(temp.elementAt(1).equals("LET US CONSIDER A GENERIC N-DIMENSIONAL SUBBUNDLE V."));
        assertTrue(temp.elementAt(2).equals("COMMENT: 18 PAGES, NO FIGURES, FINAL VERSION"));
        
        temp = resultRec.getField("OrganisaatioJulkaisija");
        assertTrue(temp.size() == 1);
        assertTrue(temp.elementAt(0).equals("MIT Press"));
        
        temp = resultRec.getField("JokuAvustaja");
        assertTrue(temp.size() == 1);
        assertTrue(temp.elementAt(0).equals(" just me "));
                
        temp = resultRec.getField("Formaatti");
        assertTrue(temp.size() == 1);
        assertTrue(temp.elementAt(0).equals("PDF"));
        
        temp = resultRec.getField("DOITunniste");
        assertTrue(temp.size() == 1);
        assertTrue(temp.elementAt(0).equals("info:doi:10.1086/312511"));
        
        temp = resultRec.getField("URLTunniste");
        assertTrue(temp.size() == 1);
        assertTrue(temp.elementAt(0).equals("http://arxiv.org/abs/astro-ph/0001087"));
        
        temp = resultRec.getField("Kieli");
        assertTrue(temp.size() == 1);
        assertTrue(temp.elementAt(0).equals("EN"));
        
        temp = resultRec.getField("Yhteys");
        assertTrue(temp.size() == 1);
        assertTrue(temp.elementAt(0).equals("test relation"));
        
        temp = resultRec.getField("Viittaustunniste");
        assertTrue(temp.size() == 1);
        assertTrue(temp.elementAt(0).equals("ABC1234"));
        
        temp = resultRec.getField("Viitattu");
        assertTrue(temp.size() == 1);
        assertTrue(temp.elementAt(0).equals("123456TEST"));
        
        temp = resultRec.getField("Viittaava");
        assertTrue(temp.size() == 1);
        assertTrue(temp.elementAt(0).equals("TEST123456"));
        
        temp = resultRec.getField("OrganisaatioOikeuksienomistaja");
        assertTrue(temp.size() == 1);
        assertTrue(temp.elementAt(0).equals("Microsoft inc. "));
                
        temp = resultRec.getField("Julkaisupäivämäärä");
        assertTrue(temp.size() == 1);
        assertTrue(temp.elementAt(0).equals("2004-08-13"));
        
    }

}
