/**
* OAICiteseerTransformerTest
* 
*
* 2.12.2005
* 
* This software is released under the GNU GPL license
* 
* @version 2.0
* @author Väinö Ala-Härkönen
* @author Reima Halmetoja
* 
* Note: Also tests DCXMLTransformWorker - its coverage is at 99%
* because of a private dummy constructor that can't be called.
*/

package maito.datacollecting.dcxml;

import junit.framework.TestCase;

import java.util.HashSet;
import java.util.Vector;

import maito.datacollecting.Record;

public class OAICiteseerTransformerTest extends TestCase {

    private Record testRec = new Record("testi");
    private Record resultRec = new Record("foo");    
    private OAICiteseerTransformer testTfm = new OAICiteseerTransformer();
        
    /**
     * When null Record is passed, causes an exception
     */
    public void testNullTransform() {

                testRec = null;
                try {
                    testTfm.transform(testRec);
                    assertTrue(false); // should never get here...
                }
                catch (Exception e) {
                    assertTrue(true);
                }
    }            
    
    /**
     * Date field test to achieve full coverage
     */
    public void testDateTransform() {           
                // Date test to achieve full coverage
                testRec = new Record("testi");
                testRec.setField("dc:date","2004-08-12");
                
                try {
                    resultRec = testTfm.transform(testRec);            
                }
                catch (Exception e) {
                    assertTrue(false);
                }
    }
    
    /**
     * Fields with only null values in source Record aren't saved at all...
     */
    public void testNullValueTransform() {            
                // test that null values aren't saved
                testRec = new Record("testi");
                testRec.setField("dc:title", null);
                testRec.setField("dc:creator", null);
                testRec.setField("dc:subject", null);
                testRec.setField("dc:date", null);
                testRec.setField("dc:subject", null);
                testRec.setField("dc:description", null);
                testRec.setField("dc:description", null);
                testRec.setField("dc:publisher", null);
                testRec.setField("dc:contributor", null);
                testRec.setField("dc:type", null);
                testRec.setField("dc:format", null);
                testRec.setField("dc:identifier", null);
                testRec.setField("dc:identifier", null);
                testRec.setField("dc:language", null);
                testRec.setField("dc:relation", null);
                testRec.setField("dc:bibliographicCitation", null);
                testRec.setField("dc:date", null);
                testRec.setField("dc:references", null);
                testRec.setField("dc:isReferencedBy", null);
                testRec.setField("dc:rightsHolder", null);
                testRec.setField("dc:issued", null); // overwrites date
                testRec.setField("oai_citeseer:identifier", null);
                testRec.setField("oai_citeseer:authorName", null);
                testRec.setField("oai_citeseer:authorAffiliation", null); 
                testRec.setField("oai_citeseer:relationIsReferencedBy", null);
                testRec.setField("oai_citeseer:relationReferences", null);                
                try {
                    resultRec = testTfm.transform(testRec);
                }
                catch (Exception e) {
                    assertTrue(false);
                }            
                HashSet fieldNames = resultRec.getFieldNames();
                assertTrue(fieldNames.isEmpty());
                
    }                
    
    /**
     * Test the standard fields
     */
    public void testStandardTransform() {            
                // The standard test: create a "normal" test record...
                testRec = new Record("testi");
                testRec.setField("dc:title", "Giambelli-type formula for subbundles of the tangent bundle");
                testRec.setField("dc:creator", "Wesley Snipes Jr.,Sylvester Stallone Jr.");
                testRec.setField("dc:creator", "Groucho Marx");
                testRec.setField("dc:subject", "Algebraic Geometry");
                testRec.setField("dc:date","2004-08-12"); // also test vs issued
                testRec.setField("dc:subject", "5R20, 57R22");
                testRec.setField("dc:description", "  Let us consider a generic n-dimensional subbundle V.");
                testRec.setField("dc:description", "Comment: 18 pages, no figures, final version");
                testRec.setField("dc:publisher","MIT Press");
                testRec.setField("dc:contributor", " just me ");
                testRec.setField("dc:type", "text");
                testRec.setField("dc:format", "pdf");
                testRec.setField("dc:identifier","info:doi:10.1086/312511");
                testRec.setField("dc:identifier","http://arxiv.org/abs/astro-ph/0001087");
                testRec.setField("dc:language", "en-US");
                testRec.setField("dc:relation","test relation");
                testRec.setField("dc:bibliographicCitation","ABC1234");
                testRec.setField("dc:date", "2004-08-12");
                testRec.setField("dc:references","123456TEST");
                testRec.setField("dc:isReferencedBy","TEST123456");
                testRec.setField("dc:rightsHolder","Microsoft inc. ");
                testRec.setField("dc:issued", "2004-08-13T12:33:44"); // overwrites date
                testRec.setField("oai_citeseer:identifier", "FOOBAR1234");
                testRec.setField("oai_citeseer:authorName", "John Smith Jr.");
                testRec.setField("oai_citeseer:authorName", "Chico Marx,Harpo Marx");
                testRec.setField("oai_citeseer:authorName", "Gandalf the gray,Saruman of many colours");
                testRec.setField("oai_citeseer:authorAffiliation", "Secret Industries"); 
                testRec.setField("oai_citeseer:relationIsReferencedBy", "citeseertest1234");
                testRec.setField("oai_citeseer:relationReferences", "citeseertest4321");
                
                // Then transform it...
                try {
                    resultRec = testTfm.transform(testRec);            
                }
                catch (Exception e) {
                    assertTrue(false);
                }
                
                Vector temp;
                assertTrue(resultRec.getID().equals("testi"));
                
                temp = resultRec.getField("Nimeke");
                assertTrue(temp.size() == 1);
                assertTrue(temp.firstElement().equals("Giambelli-type formula for subbundles of the tangent bundle"));
                
                temp = resultRec.getField("KanoNimeke");
                assertTrue(temp.size() == 1);
                assertTrue(temp.firstElement().equals("GIAMBELLI-TYPE FORMULA SUBBUNDLES TANGENT BUNDLE"));
                
                temp = resultRec.getField("HenkilöTekijä");
                //System.out.println(temp.elementAt(3));
                assertTrue(temp.size() == 7);
                assertTrue(temp.elementAt(0).equals("Wesley Snipes Jr."));
                assertTrue(temp.elementAt(1).equals("Sylvester Stallone Jr."));
                assertTrue(temp.elementAt(2).equals("John Smith Jr."));
                //The Jr. will make no difference because we know the Actor type beforehand 
                assertTrue(temp.elementAt(3).equals("Chico Marx"));
                assertTrue(temp.elementAt(4).equals("Harpo Marx"));
                assertTrue(temp.elementAt(5).equals("Gandalf the gray"));
                assertTrue(temp.elementAt(6).equals("Saruman of many colours"));
                
                temp = resultRec.getField("JokuTekijä");
                /* The name recognition heuristics in util.tools can not determine
                 * "natural" names such as these to be person-type actors
                 * (HenkilöTekijä). Instead they are categorized as "JokuTekijä".
                 */
                assertTrue(temp.size() == 1);
                assertTrue(temp.elementAt(0).equals("Groucho Marx"));
                             
                temp = resultRec.getField("Aihe");
                assertTrue(temp.size() == 2);
                assertTrue(temp.elementAt(0).equals("ALGEBRAIC GEOMETRY"));
                assertTrue(temp.elementAt(1).equals("5R20, 57R22"));
                
                temp = resultRec.getField("Hakusanat");
                assertTrue(temp.size() == 3);
                assertTrue(temp.elementAt(0).equals("TEXT"));
                assertTrue(temp.elementAt(1).equals("LET US CONSIDER A GENERIC N-DIMENSIONAL SUBBUNDLE V."));
                assertTrue(temp.elementAt(2).equals("COMMENT: 18 PAGES, NO FIGURES, FINAL VERSION"));
                
                temp = resultRec.getField("OrganisaatioJulkaisija");
                assertTrue(temp.size() == 1);
                assertTrue(temp.elementAt(0).equals("MIT Press"));
                                
                temp = resultRec.getField("JokuAvustaja");
                assertTrue(temp.size() == 1);
                assertTrue(temp.elementAt(0).equals(" just me "));
                                
                temp = resultRec.getField("Formaatti");
                assertTrue(temp.size() == 1);
                assertTrue(temp.elementAt(0).equals("PDF"));
                
                temp = resultRec.getField("DOITunniste");
                assertTrue(temp.size() == 1);
                assertTrue(temp.elementAt(0).equals("info:doi:10.1086/312511"));
                
                temp = resultRec.getField("URLTunniste");
                assertTrue(temp.size() == 1);
                assertTrue(temp.elementAt(0).equals("http://arxiv.org/abs/astro-ph/0001087"));
                
                temp = resultRec.getField("Kieli");
                assertTrue(temp.size() == 1);
                assertTrue(temp.elementAt(0).equals("EN"));
                
                temp = resultRec.getField("Yhteys");
                assertTrue(temp.size() == 1);
                assertTrue(temp.elementAt(0).equals("test relation"));
                
                temp = resultRec.getField("Viittaustunniste");
                assertTrue(temp.size() == 1);
                assertTrue(temp.elementAt(0).equals("ABC1234"));
                
                temp = resultRec.getField("Viitattu");
                assertTrue(temp.size() == 2);
                assertTrue(temp.elementAt(0).equals("citeseertest4321"));
                assertTrue(temp.elementAt(1).equals("123456TEST"));
                
                temp = resultRec.getField("Viittaava");
                assertTrue(temp.size() == 2);
                assertTrue(temp.elementAt(0).equals("TEST123456"));
                assertTrue(temp.elementAt(1).equals("citeseertest1234"));
                
                temp = resultRec.getField("OrganisaatioOikeuksienomistaja");
                assertTrue(temp.size() == 1);
                assertTrue(temp.elementAt(0).equals("Microsoft inc. "));
                
                temp = resultRec.getField("Julkaisupäivämäärä");
                assertTrue(temp.size() == 1);
                assertTrue(temp.elementAt(0).equals("2004-08-13"));
                
                temp = resultRec.getField("SisäinenTunniste");
                assertTrue(temp.size() == 1);
                assertTrue(temp.elementAt(0).equals("FOOBAR1234"));
                
                temp = resultRec.getField("OrganisaatioTekijä");
                assertTrue(temp.size() == 1);
                assertTrue(temp.elementAt(0).equals("SECRET INDUSTRIES"));
                
            }

}
