/**
* FileDataSourceTest.java
* 
* v1.0
*
* 21.11.2005
* 
* @author Väinö Ala-Härkönen
* 
* This software is released under the GNU GPL license
* 
* Note: block coverage at only 81% since one exception handling
* case is practically never reached... (it could probably be
* reached in some reproduceable way though?)
* 
* Note: creates a test file in system temp directory and deletes
* it when exiting - if the test fails, it might be because
* insufficient privileges to create the file and write to it...
*/
package maito.datacollecting.file;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.File;
import java.io.OutputStreamWriter;
import java.util.Properties;

import maito.datacollecting.DataStorage;
import maito.datacollecting.dcxml.DCXMLRecordConstructor;
import maito.datacollecting.oaipmh.OAIPMHRecordParser;
import maito.util.Tools;

import junit.framework.TestCase;

public class FileDataSourceTest extends TestCase {
    
    FileDataSource testFileDS;

    /*
     * Test method for 'maito.datacollecting.file.FileDataSource'
     */
    public void testFileDataSource() {
        OAIPMHRecordParser parser = new OAIPMHRecordParser(new DCXMLRecordConstructor(), new DataStorage(null, null, null, null));
        File tempFile;
        Properties param = new Properties();
        
        // We need a proper file for this...
        try {
            tempFile = File.createTempFile("FileDataSourceTest", null);
            tempFile.deleteOnExit();            
            BufferedWriter file = new BufferedWriter(new OutputStreamWriter(
                    new FileOutputStream(tempFile), "UTF-8"));
            file.write("<record><header></header></record>");
            file.close();
            String tempPath = tempFile.getAbsolutePath();
            System.out.println("Created a temporary file: " + tempPath);
            param.setProperty(Tools.DATASOURCE_PARAM_LOCATION, "file://" + tempPath);
        }
        catch (Exception e) {
            System.out.println("error creating test file");
            assertTrue(false);
        }
                
        Properties emptyParam = new Properties();
        Properties faultyParam = new Properties();
        faultyParam.setProperty(Tools.DATASOURCE_PARAM_LOCATION, "foobar");
        
        // Test with a proper file
        try {
            testFileDS = new FileDataSource(param, parser);
            testFileDS.update();
        }
        catch (Exception e) {
            e.printStackTrace();
            assertTrue(false);
        }
        
        // Test with faulty parameters
        try {
            testFileDS = new FileDataSource(faultyParam, parser);
            testFileDS.update();
            assertTrue(false);
        }
        catch (Exception e) {
            System.out.println(e);
            assertTrue(true);
        }
        
        // Test with null parameters
        try {
            testFileDS = new FileDataSource(null, parser);
            testFileDS.update();
            assertTrue(false);
        }
        catch (Exception e) {
            System.out.println(e);
            assertTrue(true);
        }
        
        // Test with null parser
        try {
            testFileDS = new FileDataSource(param, null);
            testFileDS.update();
            assertTrue(false);
        }
        catch (Exception e) {
            System.out.println(e);
            assertTrue(true);
        }
        
        // Test with no parameters (no baseURL found)
        try {
            testFileDS = new FileDataSource(emptyParam, parser);
            testFileDS.update();
            assertTrue(false);
        }
        catch (Exception e) {
            System.out.println(e);
            assertTrue(true);
        }
    }

}
