/**
* OAIPMHRecordParserTest.java
* 
* v1.0
*
* 17.11.2005
* 
* This software is released under the GNU GPL license
* 
* @author Väinö Ala-Härkönen
* 
* Note: This class actually tests OAIPMHRecordParser, OAICiteseerRecordConstructor
* AND DCXMLRecordConstructor. DCXMLRecordConstructWorker block coverage is achieved in
* its separate test class.
*/
package maito.datacollecting.oaipmh;

import maito.datacollecting.DataStorage;
import maito.datacollecting.dcxml.DCXMLRecordConstructor;
import maito.datacollecting.dcxml.OAICiteseerRecordConstructor;
import junit.framework.TestCase;

public class OAIPMHRecordParserTest extends TestCase {
    
    /*
     * Test method for RecordParser + citeseer record constructor
     */
    public void testCiteseer() {
        OAIPMHRecordParser parser = new OAIPMHRecordParser(new OAICiteseerRecordConstructor(), new DataStorage(null, null, null, null));
        
        String testrecord1 = "<record> <header> <identifier>oai:CiteSeerPSU:99107</identifier> " +
                "<datestamp>1996-06-07</datestamp> <setSpec>CiteSeerPSUset</setSpec> </header> " +
                "<metadata> <oai_citeseer:oai_citeseer xmlns:oai_citeseer=\"http://copper.ist.psu.edu/oai/oai_citeseer/\" xmlns:dc =\"http://purl.org/dc/elements/1.1/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://copper.ist.psu.edu/oai/oai_citeseer/ http://copper.ist.psu.edu/oai/oai_citeseer.xsd \"> " +
                "<dc:title>An Enumeration Algorithm for the Edge Coloring Problem on Bipartite Graphs</dc:title> " +
                "<oai_citeseer:author name=\"Yasuko Matsui\"> " +
                "<address>; Japan; Tokyo 113 , Japan; METR 95--09 (OCTOBER 1995)</address> " +
                "<affiliation>; Tomomi MATSUI; Tokyo Metropolitan University , Tokyo 192-03; University of Tokyo</affiliation> " +
                "</oai_citeseer:author> <dc:subject>Yasuko Matsui An Enumeration Algorithm for the Edge Coloring Problem on Bipartite Graphs</dc:subject> " +
                "<dc:description>. In this paper, we propose an algorithm for finding all the edge colorings in " +
                "bipartite graphs.</dc:description><dc:contributor>The Pennsylvania State University CiteSeer Archives</dc:contributor> " +
                "<dc:publisher>unknown</dc:publisher> <dc:date>1996-06-07</dc:date> <dc:format>ps</dc:format> " +
                "<dc:identifier>http://citeseer.ist.psu.edu/99107.html</dc:identifier> "; 
        String testrecord2 = "" +
                "<dc:source>http://misojiro.misojiro.t.u-tokyo.ac.jp/~tomomi/TRs/./METR95-09.ps.Z</dc:source> " +
                "<dc:language>en</dc:language> <oai_citeseer:relation type=\"References\"> " +
                "<oai_citeseer:uri>oai:CiteSeerPSU:48092</oai_citeseer:uri> </oai_citeseer:relation> " +
                "<oai_citeseer:relation type=\"References\"> <oai_citeseer:uri>oai:CiteSeerPSU:50984</oai_citeseer:uri> </oai_citeseer:relation> " +
                "<oai_citeseer:relation type=\"Is Referenced By\"> <oai_citeseer:uri>oai:CiteSeerPSU:8032</oai_citeseer:uri> " +
                "</oai_citeseer:relation> <oai_citeseer:relation type=\"Is Referenced By\"> <oai_citeseer:uri>oai:CiteSeerPSU:547119</oai_citeseer:uri> " +
                "</oai_citeseer:relation> <oai_citeseer:relation type=\"Is Referenced By\"> <oai_citeseer:uri>oai:CiteSeerPSU:566963</oai_citeseer:uri> " +
                "</oai_citeseer:relation> <oai_citeseer:relation type=\"Is Referenced By\"> <oai_citeseer:uri>oai:CiteSeerPSU:29249</oai_citeseer:uri> " +
                "</oai_citeseer:relation> <dc:rights>unrestricted</dc:rights> </oai_citeseer:oai_citeseer> " +
                "</metadata> </record>";
        
        try {
            parser.putData(testrecord1);
            parser.putData(testrecord2);
        }
        catch (IllegalArgumentException e) {
            assertTrue(false);
        }
                        
        String testrecord3 = "<record><header></record>";
        
        try {
            parser.putData(testrecord3);
        }
        catch (IllegalArgumentException e) { // This doesn't happen anymore - faulty records are just ignored
            assertTrue(true);
        }
        
    }
    
    /*
     * Test method for RecordParser + DC XML record constructor
     */
    public void testDCXML() {
        OAIPMHRecordParser parser2 = new OAIPMHRecordParser(new DCXMLRecordConstructor(), new DataStorage(null, null, null, null));
        
        String testrecord1 = "<record> <header> <identifier> oai:arXiv.org:alg-geom/9611016</identifier> " +
                "<datestamp> 2005-10-07</datestamp> </header> <metadata> " +
                "<oai_dc:dc xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' " +
                "xmlns:oai_dc='http://www.openarchives.org/OAI/2.0/oai_dc/' " +
                "xsi:schemaLocation='http://www.openarchives.org/OAI/2.0/oai_dc/ " +
                "http://www.openarchives.org/OAI/2.0/oai_dc.xsd' xmlns:dc='http://purl.org/dc/elements/1.1/'> " +
                "<dc:identifier> http://arxiv.org/abs/alg-geom/9611016</dc:identifier> ";
        String testrecord2 = "" +
                "<dc:creator> Kazarian, M. E.</dc:creator> <dc:creator> Shapiro, B.</dc:creator> " +
                "<dc:date> 1996-11-13</dc:date> <dc:subject> Algebraic Geometry</dc:subject> " +
                "<dc:subject> 5R20, 57R22</dc:subject> <dc:type> text</dc:type> " +
                "<dc:title> Giambelli-type formula for subbundles of the tangent bundle" +
                "</dc:title> <dc:description> Let us consider a generic n-dimensional subbundle V " +
                "of the tangent bundle TM on some given manifold M. </dc:description> " +
                "<dc:description> Comment: 18 pages, no figures, final version</dc:description> </oai_dc:dc> " +
                "</metadata> </record>";
        try {
            parser2.putData(testrecord1);
            parser2.putData(testrecord2);
        }
        catch (IllegalArgumentException e) {
            assertTrue(false);
        }
        
        String recordWithoutID = "<record></record>";
        try {
            parser2.putData(recordWithoutID);
        }
        catch (IllegalArgumentException e) {
            assertTrue(false);
        }
        
        try {
            parser2.putData(null);
        }
        catch (IllegalArgumentException e) {
            assertTrue(false);
        }
    }

}
