/**
* QuickformatRecordParserTest
* 
* v1.0
*
* 23.11.2005
* 
* This software is released under the GNU GPL license
* 
* @author Väinö Ala-Härkönen
* 
* Note: This class actually tests QuickformatRecordParser,
* QuickformatDocumentRecordConstructor and QuickformatNameRecordConstructor
*/
package maito.datacollecting.quickformat;

import maito.datacollecting.DataStorage;
import junit.framework.TestCase;

public class QuickformatRecordParserTest extends TestCase {
    
    private String nameData1 = 
        "4.1\n" +
        "olli1\n" +
        "ACM Transactions on Database Systems|Algorithms,Computational Theory\n" +
        "ACM Transactions on Information and System Security|Algorithms,Computational Theory\n" +
        "ACM Transactions on Mathematical Software|Algorithms,Computational Theory\n" +
        "ACM Transactions on Programming Languages and Systems|Algorithms,Computational Theory\n" +
        "ACM Transactions on Software Engineering and Methodology|Algorithms,Computational Theory\n\n";
    
    private String docData1 =
        "#Pikaformaatti dokumenttityyppisten resurssien metadatan esittämiseen\n" +
        "#(Itsessään validia pikaformaattidataa)\n" +
        "1\n" +
        "XYZ\n" +
        "#\n" +
        "#Risuaidalla alkavat rivit ovat kommentteja\n" +
        "\n" +
        " ---\n" +
        "Abd97ThePGP\n" +
        "1Abdul-Rahman, A.\n" +
        "2The PGP Trust Model\n" +
        "3\n" +
        "4EDI-Forum\n" +
        "51997\n" +
        "6\n" +
        "7\n" +
        "8\n" +
        "9\n" +
        " ---\n" +
        "Abe98Toward\n" +
        "1Abecker, A.\n" +
        "2Toward a Technology for Organizational Memories\n" +
        "3IEEE\n" +
        "4IEEE Intelligent Systems\n" +
        "51998\n" +
        "6Abecker, A., et al., Toward a Technology for Organizational Memories. IEEE " +
        "Intelligent Systems, May/June, 1998, 40-48.\n" +
        "7Con96Designing/Gub93ATranslational/Mil95WordNet/NoT95TheKnowledge";
    
    public void testValidParse () {
        
        QuickformatRecordParser nameParser = new QuickformatRecordParser(new QuickformatNameRecordConstructor(), new DataStorage(null, null, null, null));
        QuickformatRecordParser docParser = new QuickformatRecordParser(new QuickformatDocumentRecordConstructor(), new DataStorage(null, null, null, null));
        
        // this should work - perfectly valid data
        try {
            nameParser.putData(nameData1);
            nameParser.putData(null);
            docParser.putData(docData1);
            docParser.putData(null);
        }
        catch (IllegalArgumentException e) {
            assertTrue(false);
        }
        
        // should even work with empty lines in the end
        try {
            docParser.putData(docData1 + "\n\n\n");
            docParser.putData(null);
        }
        catch (IllegalArgumentException e) {
            assertTrue(false);
        }
        
        nameParser = new QuickformatRecordParser(new QuickformatNameRecordConstructor(), new DataStorage(null, null, null, null));
        
        // no format, should give an exception
        try {
            nameParser.putData("ACM Transactions on Database Systems|Algorithms,Computational Theory\n");  
            assertTrue(false);
        }
        catch (IllegalArgumentException e) {
            System.out.println(e);
            assertTrue(true);
        }
        
        
        docParser = new QuickformatRecordParser(new QuickformatDocumentRecordConstructor(), new DataStorage(null, null, null, null));
        
        // no data, shouldn't even give an exception
        try {
            nameParser.putData("");  
            assertTrue(true);
        }
        catch (IllegalArgumentException e) {
            System.out.println(e);
            assertTrue(false);
        }

    }
}
