/*
 * RecordReaderTest.java
 *
 * This software is released under the GNU GPL license
 *
 */

package maito.integration;

import maito.datacollecting.DataSourceDescription;
import maito.datacollecting.Record;

import java.sql.*;

import junit.framework.TestCase;

public class RecordReaderTest extends TestCase{

	public RecordReaderTest(String name) {
		super(name);
	}
	
	public void testGetRecord() throws Exception  {
		Class.forName("com.mysql.jdbc.Driver").newInstance();
		
		Connection conn = DriverManager.getConnection(
	        "jdbc:mysql://localhost/maitotest?user=maito&password=maito");
		assertTrue(conn != null);
        
        Statement s = conn.createStatement();
        
        //Clean up and setup the database first
        s.execute("TRUNCATE TABLE statement;");
        s.execute("TRUNCATE TABLE datarecord;");
        s.execute("TRUNCATE TABLE datasource;");
        
        s.execute("INSERT INTO datasource (id, format, location) " +
                  "VALUES ('storage1', 'dcxml', 'file:///C:/data/data1.xml');");
        s.execute("INSERT INTO datasource (id, format, location) " +
                  "VALUES ('storage2', 'quick_format_name', 'file:///C:/data/qfn1.dat')");
        s.execute("INSERT INTO datarecord (id, source) " +
                  "VALUES ('record1', 'storage1')");
        s.execute("INSERT INTO datarecord (id, source) " +
                  "VALUES ('record2', 'storage1')");
        s.execute("INSERT INTO datarecord (id, source) " +
                  "VALUES ('record1', 'storage2')");
        s.execute("INSERT INTO statement (name, value, record, source) " +
                  "VALUES ('Nimeke','Metadatan syvin olemus','record1','storage1');");
        s.execute("INSERT INTO statement (name, value, record, source) " +
                  "VALUES ('Author','Niinivaara O','record1','storage1');");
        s.execute("INSERT INTO statement (name, value, record, source) " +
                  "VALUES ('Nimeke','Metadata osa 2','record2','storage1');");
        s.execute("INSERT INTO statement (name, value, record, source) " +
                  "VALUES ('Author','Vanonen J','record2','storage1');");
        s.execute("INSERT INTO statement (name, value, record, source) " +
                  "VALUES ('Author','Saarekas O','record1','storage2');");
        //database ready
        
        Record r1 = new Record("record1");
        r1.setField("Nimeke", "Metadatan syvin olemus");
        r1.setField("Author", "Niinivaara O");
		
        Record r2 = new Record("record2");
        r2.setField("Nimeke", "Metadata osa 2");
        r2.setField("Author", "Vanonen J");	
        
        Record r3 = new Record("record1");
        r3.setField("Author", "Saarekas O");  
        
        DataSourceDescription d1 = new DataSourceDescription("storage1", "2005-11-23", 
                "2005-11-23", 2, "dcxml", false);
        
        DataSourceDescription d2 = new DataSourceDescription("storage2", "2005-11-23", 
                "2005-11-23", 2, "quickformat_name", false);
        
        RecordReader rr = new RecordReader(conn);
        
        //calling next record without calling getRecord first
        assertTrue(rr.nextRecord() == null);
        
        rr.getRecords(d1);
        
        assertTrue(rr.nextRecord().equals(r1));
        assertTrue(rr.nextRecord().equals(r2)); 
        
        //reset cursor
        rr.getRecords(d1);
  
        assertTrue(rr.nextRecord().equals(r1)); 
        assertTrue(rr.nextRecord().equals(r2));
        //end of resultset
        assertTrue(rr.nextRecord() == null); 
        
        rr.getRecords(d2);
        assertTrue(rr.nextRecord().equals(r3)); 
        
        conn.close();
		
	}
	
}
