package maito.resource;

import junit.framework.TestCase;
import maito.util.DbTools;
import maito.util.Tools;

import java.sql.*;

public class ResourceLoaderTest extends TestCase {

    private Connection con;
    
    public ResourceLoaderTest() {
        try {
            this.con = DbTools.createDbConnection(Tools.loadProperties("build/config/dbconfig.properties"));
            Statement stmt = this.con.createStatement();
            stmt.execute("CREATE DATABASE DATABASEMANAGERTEST CHARACTER SET utf8;");
            stmt.executeUpdate("USE DATABASEMANAGERTEST");
            
            String sqlScript = Tools.readFile("build/config/resourcegraph.sql");
            
//          execute each sql command from script
            int previous = 0;
            for (int i = sqlScript.indexOf(";", previous); i != -1; i = sqlScript
                    .indexOf(";", previous)) {

                String query = sqlScript.substring(previous, i);
                stmt.execute(query);
                previous = i + 1;
            }
        }
        catch(SQLException e) {
            e.printStackTrace();
            assertTrue(false);
        }
    }
    
    public void tearDown() {
        try {
            Statement stmt = this.con.createStatement();
            stmt.execute("DROP DATABASE DATABASEMANAGERTEST");
        }
        catch(Exception e) {
            e.printStackTrace();
        }
    }
    
    public void testLoadingResources() {
        try  {
            Statement stmt = this.con.createStatement();
            stmt.executeUpdate("insert into Resource values ('z_id','name','canonical','2005-01-01','Actor')");
            stmt.executeUpdate("insert into Actor values ('z_id','Joku')");
            
            ResourceLoader loader = new ResourceLoader(this.con);
            
            loader.executeSQL("select * from Resource");
            
            Resource resource = loader.nextResource();
            
            assertTrue(resource != null);
            
            while(!resource.getID().equals("z_id")) {
                resource = loader.nextResource();
            }
            assertTrue(resource.getType().equals("Actor"));
            assertTrue(loader.nextResource() == null);
        }
        catch(Exception e) {
            e.printStackTrace();
            assertTrue(false);
        }
    }
}
