package maito.util;

import junit.framework.TestCase;


import javax.xml.parsers.*;

import java.io.*;
import org.w3c.dom.Document;

public class XMLToolsTest extends TestCase {

    private DocumentBuilder builder;
    
    public XMLToolsTest() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            this.builder = factory.newDocumentBuilder();
        } catch (Exception e) {
            assertTrue(false);
        }
    }
    
    /**
     * Test that the text content of an element is received as it should. 
     *
     */
    public void testGetElementContent() {
        
        String xml = "<root><element attribute=\"attrvalue\">content</element></root>";
        
        try {
         
            String content = XMLTools.getNodeContent(this.builder, new ByteArrayInputStream(xml.getBytes()),
                "/root/element");
            assertTrue(content.equals("content"));
        }
        catch(Exception e) {
            assertTrue(false);
        }
        
        xml = "<root><element>content1</element><element>content2</element></root>";
        
        try {
         
            String[] contents = XMLTools.getAllContents(this.builder, new ByteArrayInputStream(xml.getBytes()),
                "/root/element");
            assertTrue(contents[0].equals("content1"));
            assertTrue(contents[1].equals("content2"));
        }
        catch(Exception e) {
            assertTrue(false);
        }
    }
    
    /**
     * Test that the text content of an attribute is received as it should. 
     *
     */
    public void testGetAttributeContent() {
        
        String xml = "<root><element attribute=\"attrvalue\">content</element></root>";
        
        try {
         
            String content = XMLTools.getNodeContent(this.builder, new ByteArrayInputStream(xml.getBytes()),
                "/root/element/@attribute");
            assertTrue(content.equals("attrvalue"));
        }
        catch(Exception e) {
            assertTrue(false);
        }
        
        xml = "<root><element attr=\"value1\"/><element attr=\"value2\"/></root>";
        
        try {
         
            String[] contents = XMLTools.getAllContents(this.builder, new ByteArrayInputStream(xml.getBytes()),
                "/root/element/@attr");
            assertTrue(contents[0].equals("value1"));
            assertTrue(contents[1].equals("value2"));
        }
        catch(Exception e) {
            assertTrue(false);
        }
    }
    
    /**
     * Test that the text content inside an element's CDATA block is received as it should. 
     *
     */
    public void testCDATAContent() {
        
        String xml = "<root><element attribute=\"attrvalue\"><![CDATA[content]]></element></root>";
        
        try {
         
            String content = XMLTools.getNodeContent(this.builder, new ByteArrayInputStream(xml.getBytes()),
                "/root/element");
            assertTrue(content.equals("content"));
        }
        catch(Exception e) {
            assertTrue(false);
        }
        xml = "<root><element><![CDATA[content1]]></element><element><![CDATA[content2]]></element></root>";
        
        try {
         
            String[] contents = XMLTools.getAllContents(this.builder, new ByteArrayInputStream(xml.getBytes()),
                "/root/element");
            assertTrue(contents[0].equals("content1"));
            assertTrue(contents[1].equals("content2"));
        }
        catch(Exception e) {
            e.printStackTrace();
            assertTrue(false);
        }
    }
    
    /**
     * Test that all elements are written to file.
     *
     */
    public void testWriteToFile() {
        String xml = "<root><element>content</element></root>";
        
        Document doc = null;
        
        try {
            doc = this.builder.parse(new ByteArrayInputStream(xml.getBytes()));
        }
        catch(Exception e) {
            assertTrue(false);
        }
        
        XMLTools.writeDocumentToFile(doc, "testfile.xml");
        
        BufferedReader reader = null;
        
        try {
            reader = new BufferedReader(new FileReader("testfile.xml"));
        }
        catch(FileNotFoundException e) {
            assertTrue(false);
        }
        
        StringBuffer fileContent = new StringBuffer();
        
        try {
            String line = reader.readLine().trim();
            
            while(line != null) {
                line = line.trim();
                fileContent.append(line);
                line = reader.readLine();
            }
         
            assertTrue(fileContent.toString().equals(xml));
        }
        catch(Exception e) {
            e.printStackTrace();
            assertTrue(false);
        }
        
        new File("testfile.xml").delete();
    }
}
