function f_out = extract_features_L(images,labels,n_wanted)
% 
% This will exhaustively extract fragment features 
% (image patches) from a given grayscale image array. 
% The sliding window step size and fragment size can
% be specified in the code. If you wish multiple fragment
% sizes, turn [16] into a vector of sizes.
%

f_out  = [];
fcount = 0;

% 1. Fragments:
pos_idx    = find(labels > 0);
pos_images = images(:,:,pos_idx);
[H,W,N]    = size(pos_images);
for h=[16],
   for w=[16],
      for i=1:5:(H-h+1),
         for j=1:5:(W-w+1),
            for n=1:N,
               patch = pos_images(i:(i+h-1),j:(j+w-1),n);
               ok = 1;
               if (max(patch(:))-min(patch(:)))<0.2,
                  % Assume that flat or low-contrast patches are not that
                  % useful...
                  %ok = 0;
               end
               if ok,
                  fcount  = fcount + 1;
                  feature = [];
                  feature.evaluator = 'fragment_evaluator';
                  feature.evaluator_params.fragment_image = patch;
                  feature.evaluator_params.source_loc = [i j n];
                  feature.evaluator_params.span = 5;
                  feature.description = 'fragment';
                  
                  f_out(fcount).feature = feature;
               end
            end
         end
      end
   end
end

M = size(f_out,2);
M
if M>=1,
   idx = randperm(M);
   %n_selected = round(M*0.5);
   n_selected = n_wanted;
   idx = idx(1:n_selected);
   f_out = f_out(idx);
   fcount = size(f_out,2); % If additional features are needed..
end

for k=1:size(f_out,2),
   f_out(k).feature.unique_id = k;
end

fprintf(1,'\nextract_features_L: %d features extracted.\n', fcount);

% End.
