function f_out = extract_features_Lseed(images,labels,seed_loc)
%
% Similar to 'extract_features_L.m' (see blurb therein) but
% with selection of the fragments from the locations specified
% in seed_loc.
%

f_out  = [];
fcount = 0;

% 1. Fragments:
pos_idx    = find(labels > 0);
pos_images = images(:,:,pos_idx);
[H,W,N]    = size(pos_images);
for h=[16],
   for w=[16],
      for s = 1:size(seed_loc,1),
         i = seed_loc(s,1)-round(h/2);
         j = seed_loc(s,2)-round(w/2);
         
         if i>=1 & j>=1 & i+h-1<=H & j+w-1<=W,
            sample_idx = randperm(N);
            sample_idx = sample_idx(1:5);
            %for n=1:N,
            for n = sample_idx,
               patch = pos_images(i:(i+h-1),j:(j+w-1),n);
               ok = 1;
               
               fcount  = fcount + 1;
               feature = [];
               feature.evaluator = 'fragment_evaluator';
               feature.evaluator_params.fragment_image = patch;
               feature.evaluator_params.source_loc = [i j n];
               feature.evaluator_params.span = 5;
               feature.description = 'fragment';
               
               f_out(fcount).feature = feature;
            end
         end
      end
   end
end

for k=1:size(f_out,2),
   f_out(k).feature.unique_id = k;
end

fprintf(1,'\nextract_features_Lseed: %d features extracted.\n', fcount);

% End.
