function out = fragment_evaluator(params,image)
% Calculates the max degree of presence for the 
% given fragment in the given image.
%
span = params.span;
I_f  = params.source_loc(1);
J_f  = params.source_loc(2);
I_start = max([1 I_f-span]);
J_start = max([1 J_f-span]);
[ht,wt] = size(image);
[ht2,wt2] = size(params.fragment_image);
I_stop  = min([ht I_f+ht2-1+span]);
J_stop  = min([wt J_f+wt2-1+span]);
image   = image(I_start:I_stop,J_start:J_stop);

cc = normxcorr2(params.fragment_image,image);
if isreal(cc),
  out = max(cc(:));
else
  out = 0;
end

% End.
