function [out_val,ok] = generate_split(data,answers)
% Finds a split point for thresholding feature presence 
%
data    = data(:);
answers = answers(:);
ok      = 0;
out_val = nan;

% Assume answers in {-1,1}
% Do not assume that the data is already sorted.
% assumes that the data does not consist of the same value all over..

% Sort the data:
[sorted_data,sorted_idx] = sort(data);
sorted_answers = answers(sorted_idx);
data    = sorted_data;
answers = sorted_answers;
clear sorted_data;
clear sorted_answers;

neg_idx  = find(answers<=0);

iset = setdiff(neg_idx,size(data,1)); 
isetplus = iset+1; 
tmp = find((answers(isetplus)>0).*(data(isetplus)>data(iset)));
if not(isempty(tmp)),
  candidates = iset(find((answers(isetplus)>0).*(data(isetplus)>data(iset))));
else
  return;
end

n_data  = size(data,1);
pos_ref = (answers>0);
neg_ref = (answers<=0);
scores  = zeros(size(candidates,1),1);
for k=1:size(candidates,1),
  i = candidates(k);
  p_x1 = (n_data-i)/n_data;  
  p_x0 = i/n_data;           
  p_pos_x1 = sum(pos_ref((i+1):n_data))/(n_data-i);
  p_pos_x0 = sum(pos_ref(1:i))/i;
  p_neg_x1 = sum(neg_ref((i+1):n_data))/(n_data-i);
  p_neg_x0 = sum(neg_ref(1:i))/i;
  H_C_X = -p_x1*(p_pos_x1*log2(p_pos_x1+eps) + p_neg_x1*log2(p_neg_x1+eps)) ...
	  -p_x0*(p_pos_x0*log2(p_pos_x0+eps) + p_neg_x0*log2(p_neg_x0+eps));
  scores(k) = H_C_X;
end
[foo,idx] = min(scores); 
idx = idx(1);
i = candidates(idx);
out_val = (data(i) + data(i+1))/2;
ok = 1;

% End.
