function g = measure_gain1c(X0_occ,labels)
% Measures the gain in including the _first_ feature
%
labels = labels(:);
reference = zeros(size(labels,1),1);
n_data    = size(labels,1);
pos = (labels>0); neg = (labels<0);
x0ref = reference; x0ref(X0_occ) = 1;

% H(C):
s = 0;
p_pos = sum(pos)/n_data;
p_neg = sum(neg)/n_data;
s = -1*(p_pos*log2(p_pos+eps)+p_neg*log2(p_neg+eps));
H_C = s;

% H(C|X0):
s = 0;
for x0=0:1,
  if x0==1,
    x0set = x0ref;
  else
    x0set = ~x0ref;
  end
  
  tmp  = x0set;
  p_x0 = sum(tmp)/n_data;
  p_pos_x0 = sum(pos.*tmp)/n_data;
  p_neg_x0 = sum(neg.*tmp)/n_data;
  if p_pos_x0 > 0,
    p_pos_given_x0 = p_pos_x0/p_x0;
  else
    p_pos_given_x0 = 0;
  end
  if p_neg_x0 > 0,
    p_neg_given_x0 = p_neg_x0/p_x0;	
  else
    p_neg_given_x0 = 0;
  end
  
  s = s -p_x0*(p_pos_given_x0*log2(p_pos_given_x0+eps)+p_neg_given_x0*log2(p_neg_given_x0+eps));
  
end
H_C_given_X0 = s;

g = H_C - H_C_given_X0;

% End.
