function g = measure_gain2c(X1_occ,X0_occ,labels)
% Measures the gain in including the feature after
% some features have already been selected. measure_gain1c.m
% can be used to measure the gain of the first feature.
%

labels = labels(:);
reference = zeros(size(labels,1),1);
n_data    = size(labels,1);
pos = (labels>0); neg = (labels<0);
x0ref = reference; x0ref(X0_occ) = 1;
x1ref = reference; x1ref(X1_occ) = 1;

% H(C|X0):
s = 0;
for x0=0:1,
  if x0==1,
    x0set = x0ref;
  else
    x0set = ~x0ref;
  end
  
  tmp  = x0set;
  p_x0 = sum(tmp)/n_data;
  p_pos_x0 = sum(pos.*tmp)/n_data;
  p_neg_x0 = sum(neg.*tmp)/n_data;
  if p_pos_x0 > 0,
    p_pos_given_x0 = p_pos_x0/p_x0;
  else
    p_pos_given_x0 = 0;
  end
  if p_neg_x0 > 0,
    p_neg_given_x0 = p_neg_x0/p_x0;	
  else
    p_neg_given_x0 = 0;
  end
  
  s = s -p_x0*(p_pos_given_x0*log2(p_pos_given_x0+eps)+p_neg_given_x0*log2(p_neg_given_x0+eps));
  
end
H_C_given_X0 = s;

% H(C|X0,X1):
s = 0;
for x0=0:1,
  if x0==1,
    x0set = x0ref;
  else
    x0set = ~x0ref;
  end
  for x1=0:1,
    if x1==1,
      x1set = x1ref;
    else
      x1set = ~x1ref;
    end  
    
    tmp = x0set.*x1set; % Intersection set indicator vector.
    p_x0_x1 = sum(tmp)/n_data;
    p_pos_x0_x1 = sum(pos.*tmp)/n_data;
    p_neg_x0_x1 = sum(neg.*tmp)/n_data;
    if p_pos_x0_x1 > 0,
      p_pos_given_x0_x1 = p_pos_x0_x1/p_x0_x1;
    else
      p_pos_given_x0_x1 = 0;
    end
    if p_neg_x0_x1 > 0,
      p_neg_given_x0_x1 = p_neg_x0_x1/p_x0_x1;	
    else
      p_neg_given_x0_x1 = 0;
    end
    
    s = s -p_x0_x1*(p_pos_given_x0_x1*log2(p_pos_given_x0_x1+eps)+p_neg_given_x0_x1*log2(p_neg_given_x0_x1+eps));
    
  end
end
H_C_given_X0_X1 = s;

g = H_C_given_X0 - H_C_given_X0_X1;

% End.
